/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.cache.redis;

import java.io.Serializable;
import org.jim.common.cache.redis.RedisConfiguration;
import org.jim.common.cache.redis.RedisConfigurationFactory;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonTemplate
implements Serializable {
    private static final long serialVersionUID = -4528751601700736437L;
    private static final Logger logger = LoggerFactory.getLogger(RedissonTemplate.class);
    private static RedissonTemplate instance = null;
    private static RedisConfiguration redisConfig = null;
    private static final String REDIS = "redis";
    private static RedissonClient redissonClient = null;

    private RedissonTemplate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedissonTemplate me() throws Exception {
        if (instance != null) return instance;
        Class<RedissonTemplate> clazz = RedissonTemplate.class;
        synchronized (RedissonTemplate.class) {
            if (instance != null) return instance;
            redisConfig = RedisConfigurationFactory.parseConfiguration();
            RedissonTemplate.init();
            instance = new RedissonTemplate();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static final void init() throws Exception {
        String host = redisConfig.getHost();
        if (host == null) {
            logger.error("the server ip of redis  must be not null!");
            throw new Exception("the server ip of redis  must be not null!");
        }
        int port = redisConfig.getPort();
        String password = redisConfig.getAuth();
        Config redissonConfig = new Config();
        SingleServerConfig singleServerConfig = redissonConfig.useSingleServer();
        ((SingleServerConfig)((SingleServerConfig)singleServerConfig.setAddress("redis://" + host + ":" + port).setPassword(password)).setTimeout(redisConfig.getTimeout())).setRetryAttempts(redisConfig.getRetryNum());
        try {
            redissonClient = Redisson.create((Config)redissonConfig);
        }
        catch (Exception e) {
            logger.error("cann't create RedissonClient for server" + redisConfig.getHost());
            throw new Exception("cann't create RedissonClient for server" + redisConfig.getHost());
        }
    }

    public final RedissonClient getRedissonClient() {
        return redissonClient;
    }
}

