/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.http;

import cn.hutool.core.util.StrUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jim.common.http.HttpConfig;
import org.jim.common.http.HttpConst;
import org.jim.common.http.HttpMultiBodyDecoder;
import org.jim.common.http.HttpRequest;
import org.jim.common.http.KeyValue;
import org.jim.common.http.Method;
import org.jim.common.http.RequestLine;
import org.jim.common.utils.HttpParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.exception.AioDecodeException;
import org.tio.core.exception.LengthOverflowException;
import org.tio.core.utils.ByteBufferUtils;

public class HttpRequestDecoder {
    private static Logger log = LoggerFactory.getLogger(HttpRequestDecoder.class);
    public static final int MAX_LENGTH_OF_HEADER = 20480;
    public static final int MAX_LENGTH_OF_HEADERLINE = 2048;

    public static HttpRequest decode(ByteBuffer buffer, ChannelContext channelContext, boolean isBody) throws AioDecodeException {
        int initPosition = buffer.position();
        int readableLength = buffer.limit() - initPosition;
        Step step = Step.firstline;
        HashMap<String, String> headers = new HashMap<String, String>();
        int contentLength = 0;
        byte[] bodyBytes = null;
        StringBuilder headerSb = new StringBuilder(512);
        RequestLine firstLine = null;
        while (buffer.hasRemaining()) {
            String line;
            try {
                line = ByteBufferUtils.readLine((ByteBuffer)buffer, null, (Integer)2048);
            }
            catch (LengthOverflowException e) {
                throw new AioDecodeException((Throwable)e);
            }
            int newPosition = buffer.position();
            if (newPosition - initPosition > 20480) {
                throw new AioDecodeException("max http header length 20480");
            }
            if (line == null) {
                return null;
            }
            headerSb.append(line).append("\r\n");
            if ("".equals(line) && isBody) {
                String contentLengthStr = (String)headers.get(HttpConst.RequestHeaderKey.Content_Length);
                contentLength = StringUtils.isBlank((CharSequence)contentLengthStr) ? 0 : Integer.parseInt(contentLengthStr);
                int headerLength = buffer.position() - initPosition;
                int allNeedLength = headerLength + contentLength;
                if (readableLength >= allNeedLength) {
                    step = Step.body;
                    break;
                }
                channelContext.setPacketNeededLength(Integer.valueOf(allNeedLength));
                return null;
            }
            if (step == Step.firstline) {
                firstLine = HttpRequestDecoder.parseRequestLine(line, channelContext);
                step = Step.header;
                continue;
            }
            if (step != Step.header) continue;
            if ("".equals(line) && !isBody) break;
            KeyValue keyValue = HttpRequestDecoder.parseHeaderLine(line);
            headers.put(keyValue.getKey(), keyValue.getValue());
        }
        if (step != Step.body && isBody) {
            return null;
        }
        if (!headers.containsKey(HttpConst.RequestHeaderKey.Host)) {
            throw new AioDecodeException("there is no host header");
        }
        HttpRequest httpRequest = new HttpRequest(channelContext.getClientNode());
        httpRequest.setChannelContext(channelContext);
        httpRequest.setHttpConfig((HttpConfig)channelContext.getGroupContext().getAttribute("TIO_HTTP_SERVER_CONFIG"));
        httpRequest.setHeaderString(headerSb.toString());
        httpRequest.setRequestLine(firstLine);
        httpRequest.setHeaders(headers);
        httpRequest.setContentLength(contentLength);
        HttpRequestDecoder.parseQueryString(httpRequest, firstLine, channelContext);
        if (contentLength != 0) {
            bodyBytes = new byte[contentLength];
            buffer.get(bodyBytes);
            httpRequest.setBody(bodyBytes);
            HttpRequestDecoder.parseBody(httpRequest, firstLine, bodyBytes, channelContext);
        }
        return httpRequest;
    }

    public static void decodeParams(Map<String, Object[]> params, String paramsStr, String charset, ChannelContext channelContext) {
        String[] keyvalues;
        if (StrUtil.isBlank((CharSequence)paramsStr)) {
            return;
        }
        for (String keyvalue : keyvalues = StringUtils.split((String)paramsStr, (String)"&")) {
            String[] newExistValue;
            String[] keyvalueArr = StringUtils.split((String)keyvalue, (String)"=");
            if (keyvalueArr.length != 2) continue;
            String key = keyvalueArr[0];
            String value = null;
            try {
                value = URLDecoder.decode(keyvalueArr[1], charset);
            }
            catch (UnsupportedEncodingException e) {
                log.error(channelContext.toString(), (Throwable)e);
            }
            Object[] existValue = params.get(key);
            if (existValue != null) {
                newExistValue = new String[existValue.length + 1];
                System.arraycopy(existValue, 0, newExistValue, 0, existValue.length);
                newExistValue[newExistValue.length - 1] = value;
                params.put(key, newExistValue);
                continue;
            }
            newExistValue = new String[]{value};
            params.put(key, newExistValue);
        }
    }

    public static void main(String[] args) {
    }

    private static void parseBody(HttpRequest httpRequest, RequestLine firstLine, byte[] bodyBytes, ChannelContext channelContext) throws AioDecodeException {
        HttpRequestDecoder.parseBodyFormat(httpRequest, httpRequest.getHeaders());
        HttpConst.RequestBodyFormat bodyFormat = httpRequest.getBodyFormat();
        httpRequest.setBody(bodyBytes);
        if (bodyFormat == HttpConst.RequestBodyFormat.MULTIPART) {
            if (log.isInfoEnabled()) {
                String bodyString = null;
                if (bodyBytes != null && bodyBytes.length > 0 && log.isDebugEnabled()) {
                    try {
                        bodyString = new String(bodyBytes, httpRequest.getCharset());
                        log.debug("{} multipart body string\r\n{}", (Object)channelContext, (Object)bodyString);
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error(channelContext.toString(), (Throwable)e);
                    }
                }
            }
            String initboundary = HttpParseUtils.getPerprotyEqualValue(httpRequest.getHeaders(), HttpConst.RequestHeaderKey.Content_Type, "boundary");
            log.debug("{}, initboundary:{}", (Object)channelContext, (Object)initboundary);
            HttpMultiBodyDecoder.decode(httpRequest, firstLine, bodyBytes, initboundary, channelContext);
        } else {
            String bodyString = null;
            if (bodyBytes != null && bodyBytes.length > 0) {
                try {
                    bodyString = new String(bodyBytes, httpRequest.getCharset());
                    httpRequest.setBodyString(bodyString);
                    if (log.isInfoEnabled()) {
                        log.info("{} body string\r\n{}", (Object)channelContext, (Object)bodyString);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    log.error(channelContext.toString(), (Throwable)e);
                }
            }
            if (bodyFormat == HttpConst.RequestBodyFormat.URLENCODED) {
                HttpRequestDecoder.parseUrlencoded(httpRequest, firstLine, bodyBytes, bodyString, channelContext);
            }
        }
    }

    public static void parseBodyFormat(HttpRequest httpRequest, Map<String, String> headers) {
        String charset;
        String Content_Type2 = StringUtils.lowerCase((String)headers.get(HttpConst.RequestHeaderKey.Content_Type));
        HttpConst.RequestBodyFormat bodyFormat = null;
        bodyFormat = StringUtils.contains((CharSequence)Content_Type2, (CharSequence)HttpConst.RequestHeaderValue.Content_Type.application_x_www_form_urlencoded) ? HttpConst.RequestBodyFormat.URLENCODED : (StringUtils.contains((CharSequence)Content_Type2, (CharSequence)HttpConst.RequestHeaderValue.Content_Type.multipart_form_data) ? HttpConst.RequestBodyFormat.MULTIPART : HttpConst.RequestBodyFormat.TEXT);
        httpRequest.setBodyFormat(bodyFormat);
        if (StringUtils.isNotBlank((CharSequence)Content_Type2) && StringUtils.isNotBlank((CharSequence)(charset = HttpParseUtils.getPerprotyEqualValue(headers, HttpConst.RequestHeaderKey.Content_Type, "charset")))) {
            httpRequest.setCharset(charset);
        }
    }

    public static KeyValue parseHeaderLine(String line) {
        KeyValue keyValue = new KeyValue();
        int p = line.indexOf(":");
        if (p == -1) {
            keyValue.setKey(line);
            return keyValue;
        }
        String name = StringUtils.lowerCase((String)line.substring(0, p).trim());
        String value = line.substring(p + 1).trim();
        keyValue.setKey(name);
        keyValue.setValue(value);
        return keyValue;
    }

    public static RequestLine parseRequestLine(String line, ChannelContext channelContext) throws AioDecodeException {
        try {
            int index1 = line.indexOf(32);
            String _method = StringUtils.upperCase((String)line.substring(0, index1));
            Method method = Method.from(_method);
            int index2 = line.indexOf(32, index1 + 1);
            String pathAndQuerystr = line.substring(index1 + 1, index2);
            String path = null;
            String queryStr = null;
            int indexOfQuestionmark = pathAndQuerystr.indexOf("?");
            if (indexOfQuestionmark != -1) {
                queryStr = StringUtils.substring((String)pathAndQuerystr, (int)(indexOfQuestionmark + 1));
                path = StringUtils.substring((String)pathAndQuerystr, (int)0, (int)indexOfQuestionmark);
            } else {
                path = pathAndQuerystr;
                queryStr = "";
            }
            String protocolVersion = line.substring(index2 + 1);
            String[] pv = StringUtils.split((String)protocolVersion, (String)"/");
            String protocol = pv[0];
            String version = pv[1];
            RequestLine requestLine = new RequestLine();
            requestLine.setMethod(method);
            requestLine.setPath(path);
            requestLine.setInitPath(path);
            requestLine.setPathAndQuery(pathAndQuerystr);
            requestLine.setQuery(queryStr);
            requestLine.setVersion(version);
            requestLine.setProtocol(protocol);
            requestLine.setLine(line);
            return requestLine;
        }
        catch (Throwable e) {
            log.error(channelContext.toString(), e);
            throw new AioDecodeException(e);
        }
    }

    private static void parseUrlencoded(HttpRequest httpRequest, RequestLine firstLine, byte[] bodyBytes, String bodyString, ChannelContext channelContext) {
        if (StringUtils.isNotBlank((CharSequence)bodyString)) {
            HttpRequestDecoder.decodeParams(httpRequest.getParams(), bodyString, httpRequest.getCharset(), channelContext);
        }
    }

    private static void parseQueryString(HttpRequest httpRequest, RequestLine firstLine, ChannelContext channelContext) {
        String paramStr = firstLine.getQuery();
        if (StringUtils.isNotBlank((CharSequence)paramStr)) {
            HttpRequestDecoder.decodeParams(httpRequest.getParams(), paramStr, httpRequest.getCharset(), channelContext);
        }
    }

    public static enum Step {
        firstline,
        header,
        body;

    }
}

