/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.http;

import org.jim.common.Status;

public enum HttpResponseStatus implements Status
{
    C100(100, "Continue", "100 Continue"),
    C101(101, "Switching Protocols", "101 Switching Protocols"),
    C200(200, "OK", "200 OK"),
    C201(201, "Created", "201 Created"),
    C202(202, "Accepted", "202 Accepted"),
    C203(203, "Non-Authoritative Information", "203 Non-Authoritative Information"),
    C204(204, "No Content", "204 No Content"),
    C205(205, "Reset Content", "205 Reset Content"),
    C206(206, "Partial Content", "206 Partial Content"),
    C300(300, "Multiple Choices", "300 Multiple Choices"),
    C301(301, "Moved Permanently", "301 Moved Permanently"),
    C302(302, "Found", "302 Found"),
    C303(303, "See Other", "303 See Other"),
    C304(304, "Not Modified", "304 Not Modified"),
    C305(305, "Use Proxy", "305 Use Proxy"),
    C307(307, "Temporary Redirect", "307 Temporary Redirect"),
    C400(400, "Bad Request", "400 Bad Request"),
    C401(401, "Unauthorized", "401 Unauthorized"),
    C403(403, "Forbidden", "403 Forbidden"),
    C404(404, "Not Found", "404 Not Found"),
    C405(405, "Method Not Allowed", "405 Method Not Allowed"),
    C406(406, "Not Acceptable", "406 Not Acceptable"),
    C407(407, "Proxy Authentication Required", "407 Proxy Authentication Required"),
    C408(408, "Request Timeout", "408 Request Timeout"),
    C409(409, "Conflict", "409 Conflict"),
    C410(410, "Gone", "410 Gone"),
    C411(411, "Length Required", "411 Length Required"),
    C412(412, "Precondition Failed", "412 Precondition Failed"),
    C413(413, "Request Entity Too Large", "413 Request Entity Too Large"),
    C414(414, "Request URI Too Long", "414 Request URI Too Long"),
    C416(416, "Requested Range Not Satisfiable", "416 Requested Range Not Satisfiable"),
    C500(500, "Internal Server Error", "500 Internal Server Error"),
    C501(501, "Not Implemented", "501 Not Implemented"),
    C502(502, "Bad Gateway", "502 Bad Gateway"),
    C503(503, "Service Unavailable", "503 Service Unavailable"),
    C504(504, "Gateway Timeout", "504 Gateway Timeout"),
    C505(505, "HTTP Version Not Supported", "505 HTTP Version Not Supported");

    private int status;
    private String description;
    private String headerText;
    private byte[] headerBinary;

    public static HttpResponseStatus getHttpStatus(int status) {
        HttpResponseStatus[] values;
        for (HttpResponseStatus v : values = HttpResponseStatus.values()) {
            if (v.getStatus() != status) continue;
            return v;
        }
        return C505;
    }

    private HttpResponseStatus(int status, String description, String headerText) {
        this.status = status;
        this.description = description;
        this.headerText = headerText;
        this.headerBinary = headerText.getBytes();
    }

    public String getDescription() {
        return this.description;
    }

    public byte[] getHeaderBinary() {
        return this.headerBinary;
    }

    public String getHeaderText() {
        return this.headerText;
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public int getCode() {
        return this.status;
    }

    @Override
    public String getMsg() {
        return this.headerText;
    }
}

