/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.http.session;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jim.common.ImSessionContext;
import org.jim.common.http.HttpConfig;

public class HttpSession
extends ImSessionContext
implements Serializable {
    private static final long serialVersionUID = 6077020620501316538L;
    private Map<String, Serializable> data = new ConcurrentHashMap<String, Serializable>();
    private String id = null;

    public HttpSession() {
    }

    public HttpSession(String id) {
        this.id = id;
    }

    public void clear(HttpConfig httpConfig) {
        this.data.clear();
        httpConfig.getSessionStore().put(this.id, (Serializable)this);
    }

    public Object getAttribute(String key) {
        return this.data.get(key);
    }

    public Map<String, Serializable> getData() {
        return this.data;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void removeAttribute(String key, HttpConfig httpConfig) {
        this.data.remove(key);
        httpConfig.getSessionStore().put(this.id, (Serializable)this);
    }

    public void setAttribute(String key, Serializable value, HttpConfig httpConfig) {
        this.data.put(key, value);
        httpConfig.getSessionStore().put(this.id, (Serializable)this);
    }

    public void setData(Map<String, Serializable> data) {
        this.data = data;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}

