/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.tcp;

import java.nio.ByteBuffer;
import org.jim.common.ImPacket;
import org.jim.common.ImSessionContext;
import org.jim.common.protocol.AbProtocol;
import org.jim.common.protocol.IConvertProtocolPacket;
import org.jim.common.tcp.TcpConvertPacket;
import org.jim.common.tcp.TcpPacket;
import org.jim.common.tcp.TcpSessionContext;
import org.jim.common.utils.ImUtils;
import org.tio.core.ChannelContext;

public class TcpProtocol
extends AbProtocol {
    @Override
    public String name() {
        return "tcp";
    }

    @Override
    public boolean isProtoc(ByteBuffer buffer, ChannelContext channelContext) throws Throwable {
        byte version;
        ImSessionContext imSessionContext = (ImSessionContext)channelContext.getAttribute();
        if (imSessionContext != null && imSessionContext instanceof TcpSessionContext) {
            return true;
        }
        if (buffer != null && (version = buffer.get()) == 1) {
            channelContext.setAttribute((Object)new TcpSessionContext());
            ImUtils.setClient(channelContext);
            return true;
        }
        return false;
    }

    @Override
    public IConvertProtocolPacket convertor() {
        return new TcpConvertPacket();
    }

    @Override
    public boolean isProtocol(ImPacket imPacket, ChannelContext channelContext) throws Throwable {
        if (imPacket == null) {
            return false;
        }
        if (imPacket instanceof TcpPacket) {
            Object sessionContext = channelContext.getAttribute();
            if (sessionContext == null) {
                channelContext.setAttribute((Object)new TcpSessionContext());
            }
            return true;
        }
        return false;
    }
}

