/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.tcp;

import java.nio.ByteBuffer;
import org.apache.log4j.Logger;
import org.jim.common.ImPacket;
import org.jim.common.ImStatus;
import org.jim.common.packets.Command;
import org.jim.common.tcp.TcpPacket;
import org.tio.core.ChannelContext;
import org.tio.core.exception.AioDecodeException;
import org.tio.core.intf.Packet;

public class TcpServerDecoder {
    private static Logger logger = Logger.getLogger(TcpServerDecoder.class);

    public static TcpPacket decode(ByteBuffer buffer, ChannelContext channelContext) throws AioDecodeException {
        byte cmdByte;
        if (!TcpServerDecoder.isHeaderLength(buffer)) {
            return null;
        }
        byte version = buffer.get();
        if (version != 1) {
            throw new AioDecodeException(ImStatus.C10013.getText());
        }
        byte maskByte = buffer.get();
        Integer synSeq = 0;
        if (ImPacket.decodeHasSynSeq(maskByte)) {
            synSeq = buffer.getInt();
        }
        if (Command.forNumber(cmdByte = buffer.get()) == null) {
            throw new AioDecodeException(ImStatus.C10014.getText());
        }
        int bodyLen = buffer.getInt();
        if (bodyLen < 0) {
            throw new AioDecodeException("bodyLength [" + bodyLen + "] is not right, remote:" + channelContext.getClientNode());
        }
        int readableLength = buffer.limit() - buffer.position();
        int validateBodyLen = readableLength - bodyLen;
        if (validateBodyLen < 0) {
            return null;
        }
        byte[] body = new byte[bodyLen];
        try {
            buffer.get(body, 0, bodyLen);
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
        logger.info((Object)"TCP\u89e3\u7801\u6210\u529f...");
        TcpPacket tcpPacket = new TcpPacket(Command.forNumber(cmdByte), body);
        tcpPacket.setVersion(version);
        tcpPacket.setMask(maskByte);
        if (synSeq > 0) {
            tcpPacket.setSynSeq(synSeq);
            try {
                channelContext.getGroupContext().getAioHandler().handler((Packet)tcpPacket, channelContext);
            }
            catch (Exception e) {
                logger.error((Object)("\u540c\u6b65\u53d1\u9001\u89e3\u7801\u8c03\u7528handler\u5f02\u5e38!" + e));
            }
        }
        return tcpPacket;
    }

    private static boolean isHeaderLength(ByteBuffer buffer) throws AioDecodeException {
        int readableLength = buffer.limit() - buffer.position();
        if (readableLength == 0) {
            return false;
        }
        int index = buffer.position();
        try {
            buffer.get(index);
            byte maskByte = buffer.get(++index);
            if (ImPacket.decodeHasSynSeq(maskByte)) {
                index += 4;
            }
            buffer.get(++index);
            buffer.getInt(++index);
            index += 4;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

