/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.ws;

import java.nio.ByteBuffer;
import org.jim.common.ImPacket;
import org.jim.common.ImSessionContext;
import org.jim.common.http.HttpConst;
import org.jim.common.http.HttpRequest;
import org.jim.common.http.HttpRequestDecoder;
import org.jim.common.protocol.AbProtocol;
import org.jim.common.protocol.IConvertProtocolPacket;
import org.jim.common.utils.ImUtils;
import org.jim.common.ws.WsConvertPacket;
import org.jim.common.ws.WsPacket;
import org.jim.common.ws.WsSessionContext;
import org.tio.core.ChannelContext;

public class WsProtocol
extends AbProtocol {
    @Override
    public String name() {
        return "ws";
    }

    @Override
    public boolean isProtoc(ByteBuffer buffer, ChannelContext channelContext) throws Throwable {
        HttpRequest request;
        ImSessionContext imSessionContext = (ImSessionContext)channelContext.getAttribute();
        if (imSessionContext != null && imSessionContext instanceof WsSessionContext) {
            return true;
        }
        if (buffer != null && (request = HttpRequestDecoder.decode(buffer, channelContext, false)).getHeaders().get(HttpConst.RequestHeaderKey.Sec_WebSocket_Key) != null) {
            channelContext.setAttribute((Object)new WsSessionContext());
            ImUtils.setClient(channelContext);
            return true;
        }
        return false;
    }

    @Override
    public IConvertProtocolPacket convertor() {
        return new WsConvertPacket();
    }

    @Override
    public boolean isProtocol(ImPacket imPacket, ChannelContext channelContext) throws Throwable {
        if (imPacket == null) {
            return false;
        }
        if (imPacket instanceof WsPacket) {
            Object sessionContext = channelContext.getAttribute();
            if (sessionContext == null) {
                channelContext.setAttribute((Object)new WsSessionContext());
            }
            return true;
        }
        return false;
    }
}

