/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.ws;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jim.common.http.HttpConst;
import org.jim.common.http.HttpRequest;
import org.jim.common.http.HttpResponse;
import org.jim.common.http.HttpResponseStatus;
import org.jim.common.utils.BASE64Util;
import org.jim.common.utils.SHA1Util;
import org.jim.common.ws.Opcode;
import org.jim.common.ws.WsRequestPacket;
import org.jim.common.ws.WsSessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.exception.AioDecodeException;
import org.tio.core.utils.ByteBufferUtils;

public class WsServerDecoder {
    private static Logger log = LoggerFactory.getLogger(WsServerDecoder.class);

    public static WsRequestPacket decode(ByteBuffer buf, ChannelContext channelContext) throws AioDecodeException {
        boolean hasMask;
        int headLength;
        WsSessionContext imSessionContext = (WsSessionContext)channelContext.getAttribute();
        List<byte[]> lastParts = imSessionContext.getLastParts();
        int initPosition = buf.position();
        int readableLength = buf.limit() - initPosition;
        if (readableLength < (headLength = 2)) {
            return null;
        }
        byte first = buf.get();
        boolean fin = (first & 0x80) > 0;
        int rsv = (first & 0x70) >>> 4;
        byte opCodeByte = (byte)(first & 0xF);
        Opcode opcode = Opcode.valueOf(opCodeByte);
        byte second = buf.get();
        boolean bl = hasMask = (second & 0xFF) >> 7 == 1;
        if (hasMask) {
            headLength += 4;
        }
        int payloadLength = second & 0x7F;
        byte[] mask = null;
        if (payloadLength == 126) {
            if (readableLength < (headLength += 2)) {
                return null;
            }
            payloadLength = ByteBufferUtils.readUB2WithBigEdian((ByteBuffer)buf);
            log.info("{} payloadLengthFlag: 126\uff0cpayloadLength {}", (Object)channelContext, (Object)payloadLength);
        } else if (payloadLength == 127) {
            if (readableLength < (headLength += 8)) {
                return null;
            }
            payloadLength = (int)buf.getLong();
            log.info("{} payloadLengthFlag: 127\uff0cpayloadLength {}", (Object)channelContext, (Object)payloadLength);
        }
        if (payloadLength < 0 || payloadLength > 524288) {
            throw new AioDecodeException("body length(" + payloadLength + ") is not right");
        }
        if (readableLength < headLength + payloadLength) {
            return null;
        }
        if (hasMask) {
            mask = ByteBufferUtils.readBytes((ByteBuffer)buf, (int)4);
        }
        WsRequestPacket websocketPacket = new WsRequestPacket();
        websocketPacket.setWsEof(fin);
        websocketPacket.setWsHasMask(hasMask);
        websocketPacket.setWsMask(mask);
        websocketPacket.setWsOpcode(opcode);
        websocketPacket.setWsBodyLength(payloadLength);
        if (payloadLength == 0) {
            return websocketPacket;
        }
        byte[] array = ByteBufferUtils.readBytes((ByteBuffer)buf, (int)payloadLength);
        if (hasMask) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = (byte)(array[i] ^ mask[i % 4]);
            }
        }
        if (!fin) {
            if (lastParts == null) {
                lastParts = new ArrayList<byte[]>();
                imSessionContext.setLastParts(lastParts);
            }
            lastParts.add(array);
            log.error("payloadLength {}, lastParts size {}, array length {}", new Object[]{payloadLength, lastParts.size(), array.length});
            return websocketPacket;
        }
        int allLength = array.length;
        if (lastParts != null) {
            for (byte[] part : lastParts) {
                allLength += part.length;
            }
            byte[] allByte = new byte[allLength];
            int offset = 0;
            for (byte[] part : lastParts) {
                System.arraycopy(part, 0, allByte, offset, part.length);
                offset += part.length;
            }
            System.arraycopy(array, 0, allByte, offset, array.length);
            array = allByte;
        }
        websocketPacket.setBody(array);
        if (opcode != Opcode.BINARY) {
            try {
                String text = null;
                text = new String(array, "utf-8");
                websocketPacket.setWsBodyText(text);
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
        imSessionContext.setLastParts(null);
        return websocketPacket;
    }

    public static HttpResponse updateWebSocketProtocol(HttpRequest request, ChannelContext channelContext) {
        Map<String, String> headers = request.getHeaders();
        String Sec_WebSocket_Key = headers.get(HttpConst.RequestHeaderKey.Sec_WebSocket_Key);
        if (StringUtils.isNotBlank((CharSequence)Sec_WebSocket_Key)) {
            String Sec_WebSocket_Key_Magic = Sec_WebSocket_Key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
            byte[] key_array = SHA1Util.SHA1(Sec_WebSocket_Key_Magic);
            String acceptKey = BASE64Util.byteArrayToBase64(key_array);
            HttpResponse httpResponse = new HttpResponse(request, null);
            httpResponse.setStatus(HttpResponseStatus.C101);
            HashMap<String, String> respHeaders = new HashMap<String, String>();
            respHeaders.put(HttpConst.ResponseHeaderKey.Connection, HttpConst.ResponseHeaderValue.Connection.Upgrade);
            respHeaders.put(HttpConst.ResponseHeaderKey.Upgrade, "WebSocket");
            respHeaders.put(HttpConst.ResponseHeaderKey.Sec_WebSocket_Accept, acceptKey);
            httpResponse.setHeaders(respHeaders);
            return httpResponse;
        }
        return null;
    }

    public static enum Step {
        header,
        remain_header,
        data;

    }
}

