/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.ws;

import java.nio.ByteBuffer;
import org.jim.common.ws.WsResponsePacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.utils.ByteBufferUtils;

public class WsServerEncoder {
    private static Logger log = LoggerFactory.getLogger(WsServerEncoder.class);
    public static final int MAX_HEADER_LENGTH = 20480;

    private static void checkLength(byte[] bytes, int length, int offset) {
        if (bytes == null) {
            throw new IllegalArgumentException("null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("invalidate offset " + offset);
        }
        if (bytes.length - offset < length) {
            throw new IllegalArgumentException("invalidate length " + bytes.length);
        }
    }

    public static ByteBuffer encode(WsResponsePacket wsResponsePacket, GroupContext groupContext, ChannelContext channelContext) {
        byte[] imBody = wsResponsePacket.getBody();
        int wsBodyLength = 0;
        if (imBody != null) {
            wsBodyLength += imBody.length;
        }
        byte header0 = (byte)(0x8F & (wsResponsePacket.getWsOpcode().getCode() | 0xF0));
        ByteBuffer buf = null;
        if (wsBodyLength < 126) {
            buf = ByteBuffer.allocate(2 + wsBodyLength);
            buf.put(header0);
            buf.put((byte)wsBodyLength);
        } else if (wsBodyLength < 65535) {
            buf = ByteBuffer.allocate(4 + wsBodyLength);
            buf.put(header0);
            buf.put((byte)126);
            ByteBufferUtils.writeUB2WithBigEdian((ByteBuffer)buf, (int)wsBodyLength);
        } else {
            buf = ByteBuffer.allocate(10 + wsBodyLength);
            buf.put(header0);
            buf.put((byte)127);
            buf.put(new byte[]{0, 0, 0, 0});
            ByteBufferUtils.writeUB4WithBigEdian((ByteBuffer)buf, (long)wsBodyLength);
        }
        if (imBody != null && imBody.length > 0) {
            buf.put(imBody);
        }
        return buf;
    }

    public static void int2Byte(byte[] bytes, int value, int offset) {
        WsServerEncoder.checkLength(bytes, 4, offset);
        bytes[offset + 3] = (byte)(value & 0xFF);
        bytes[offset + 2] = (byte)(value >> 8 & 0xFF);
        bytes[offset + 1] = (byte)(value >> 16 & 0xFF);
        bytes[offset + 0] = (byte)(value >> 24);
    }
}

