/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.javalite.activejdbc.CaseInsensitiveMap;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.LogFilter;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.cache.CacheManager;
import org.javalite.activejdbc.dialects.DefaultDialect;
import org.javalite.activejdbc.dialects.Dialect;
import org.javalite.activejdbc.dialects.H2Dialect;
import org.javalite.activejdbc.dialects.MSSQLDialect;
import org.javalite.activejdbc.dialects.MySQLDialect;
import org.javalite.activejdbc.dialects.OracleDialect;
import org.javalite.activejdbc.dialects.PostgreSQLDialect;
import org.javalite.activejdbc.dialects.SQLiteDialect;
import org.javalite.common.Convert;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private Map<String, List<String>> modelsMap = new HashMap<String, List<String>>();
    private Properties properties = new Properties();
    private static CacheManager cacheManager;
    private static final Logger logger;
    private Map<String, Dialect> dialects = new CaseInsensitiveMap<Dialect>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Configuration() {
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("activejdbc_models.properties");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                LogFilter.log(logger, "Load models from: {}", (Object)url.toExternalForm());
                InputStream inputStream = null;
                InputStreamReader isreader = null;
                BufferedReader reader = null;
                try {
                    String line;
                    inputStream = url.openStream();
                    isreader = new InputStreamReader(inputStream);
                    reader = new BufferedReader(isreader);
                    while ((line = reader.readLine()) != null) {
                        String[] parts = Util.split((String)line, (char)':');
                        String modelName = parts[0];
                        String dbName = parts[1];
                        List<String> modelNames = this.modelsMap.get(dbName);
                        if (modelNames == null) {
                            modelNames = new ArrayList<String>();
                            this.modelsMap.put(dbName, modelNames);
                        }
                        modelNames.add(modelName);
                    }
                }
                catch (Throwable throwable) {
                    Util.closeQuietly(reader);
                    Util.closeQuietly(isreader);
                    Util.closeQuietly((Closeable)inputStream);
                    throw throwable;
                }
                Util.closeQuietly((Closeable)reader);
                Util.closeQuietly((Closeable)isreader);
                Util.closeQuietly((Closeable)inputStream);
            }
        }
        catch (IOException e) {
            throw new InitException(e);
        }
        if (this.modelsMap.isEmpty()) {
            LogFilter.log(logger, "ActiveJDBC Warning: Cannot locate any models, assuming project without models.");
            return;
        }
        try {
            InputStream in = this.getClass().getResourceAsStream("/activejdbc.properties");
            if (in != null) {
                this.properties.load(in);
            }
        }
        catch (IOException e) {
            throw new InitException(e);
        }
        String cacheManagerClass = this.properties.getProperty("cache.manager");
        if (cacheManagerClass == null) return;
        try {
            Class<?> cmc = Class.forName(cacheManagerClass);
            cacheManager = (CacheManager)cmc.newInstance();
            return;
        }
        catch (Exception e) {
            throw new InitException("failed to initialize a CacheManager. Please, ensure that the property 'cache.manager' points to correct class which extends 'org.javalite.activejdbc.cache.CacheManager' class and provides a default constructor.", e);
        }
    }

    List<String> getModelNames(String dbName) throws IOException {
        return this.modelsMap.get(dbName);
    }

    public boolean collectStatistics() {
        return Convert.toBoolean((Object)this.properties.getProperty("collectStatistics", "false"));
    }

    public boolean collectStatisticsOnHold() {
        return Convert.toBoolean((Object)this.properties.getProperty("collectStatisticsOnHold", "false"));
    }

    public boolean cacheEnabled() {
        return cacheManager != null;
    }

    Dialect getDialect(MetaModel mm) {
        Dialect dialect = this.dialects.get(mm.getDbType());
        if (dialect == null) {
            dialect = mm.getDbType().equalsIgnoreCase("Oracle") ? new OracleDialect() : (mm.getDbType().equalsIgnoreCase("MySQL") ? new MySQLDialect() : (mm.getDbType().equalsIgnoreCase("PostgreSQL") ? new PostgreSQLDialect() : (mm.getDbType().equalsIgnoreCase("h2") ? new H2Dialect() : (mm.getDbType().equalsIgnoreCase("Microsoft SQL Server") ? new MSSQLDialect() : (mm.getDbType().equalsIgnoreCase("SQLite") ? new SQLiteDialect() : new DefaultDialect())))));
            this.dialects.put(mm.getDbType(), dialect);
        }
        return dialect;
    }

    public CacheManager getCacheManager() {
        return cacheManager;
    }

    static {
        logger = LoggerFactory.getLogger(Configuration.class);
    }
}

