/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.javalite.activejdbc.ConnectionJdbcSpec;
import org.javalite.activejdbc.ConnectionJndiSpec;
import org.javalite.activejdbc.ConnectionSpec;
import org.javalite.activejdbc.ConnectionsAccess;
import org.javalite.activejdbc.DBException;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.LogFilter;
import org.javalite.activejdbc.RowListener;
import org.javalite.activejdbc.RowListenerAdapter;
import org.javalite.activejdbc.RowProcessor;
import org.javalite.activejdbc.StatementCache;
import org.javalite.common.Convert;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DB {
    private static final Logger logger = LoggerFactory.getLogger(DB.class);
    static final Pattern SELECT_PATTERN = Pattern.compile("^\\s*SELECT", 10);
    static final Pattern INSERT_PATTERN = Pattern.compile("^\\s*INSERT", 10);
    public static final String DEFAULT_NAME = "default";
    private final String name;

    public DB(String name) {
        this.name = name;
    }

    public void open(String driver, String url, String user, String password) {
        this.checkExistingConnection(this.name);
        try {
            Class.forName(driver);
            Connection connection = DriverManager.getConnection(url, user, password);
            ConnectionsAccess.attach(this.name, connection, url);
        }
        catch (Exception e) {
            throw new InitException("Failed to connect to JDBC URL: " + url, e);
        }
    }

    public void open(String driver, String url, Properties props) {
        this.checkExistingConnection(this.name);
        try {
            Class.forName(driver);
            Connection connection = DriverManager.getConnection(url, props);
            ConnectionsAccess.attach(this.name, connection, url);
        }
        catch (Exception e) {
            throw new InitException("Failed to connect to JDBC URL: " + url, e);
        }
    }

    public void open(String jndiName) {
        this.checkExistingConnection(this.name);
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(jndiName);
            Connection connection = ds.getConnection();
            ConnectionsAccess.attach(this.name, connection, jndiName);
        }
        catch (Exception e) {
            throw new InitException("Failed to connect to JNDI name: " + jndiName, e);
        }
    }

    public void attach(Connection connection) {
        ConnectionsAccess.attach(this.name, connection, "");
    }

    public Connection detach() {
        Connection connection = ConnectionsAccess.getConnection(this.name);
        try {
            if (connection == null) {
                throw new DBException("cannot detach connection '" + this.name + "' because it is not available");
            }
            ConnectionsAccess.detach(this.name);
            StatementCache.instance().cleanStatementCache(connection);
        }
        catch (DBException e) {
            logger.warn("Could not close connection! MUST INVESTIGATE POTENTIAL CONNECTION LEAK!", (Throwable)e);
        }
        return connection;
    }

    public void open(DataSource datasource) {
        this.checkExistingConnection(this.name);
        try {
            Connection connection = datasource.getConnection();
            ConnectionsAccess.attach(this.name, connection, datasource.toString());
        }
        catch (SQLException e) {
            throw new InitException(e);
        }
    }

    public void open(String jndiName, Properties jndiProperties) {
        this.checkExistingConnection(this.name);
        try {
            InitialContext ctx = new InitialContext(jndiProperties);
            DataSource ds = (DataSource)ctx.lookup(jndiName);
            Connection connection = ds.getConnection();
            ConnectionsAccess.attach(this.name, connection, jndiProperties.contains("url") ? jndiProperties.getProperty("url") : jndiName);
        }
        catch (Exception e) {
            throw new InitException("Failed to connect to JNDI name: " + jndiName, e);
        }
    }

    public void open(ConnectionSpec spec) {
        this.checkExistingConnection(this.name);
        if (spec instanceof ConnectionJdbcSpec) {
            this.openJdbc((ConnectionJdbcSpec)spec);
        } else if (spec instanceof ConnectionJndiSpec) {
            this.openJndi((ConnectionJndiSpec)spec);
        } else {
            throw new IllegalArgumentException("this spec not supported: " + spec.getClass());
        }
    }

    private void checkExistingConnection(String name) {
        if (null != ConnectionsAccess.getConnection(name)) {
            throw new DBException("Cannot open a new connection because existing connection is still on current thread, name: " + name + ", connection instance: " + this.connection() + ". This might indicate a logical error in your application.");
        }
    }

    private void openJdbc(ConnectionJdbcSpec spec) {
        if (spec.getProps() != null) {
            this.open(spec.getDriver(), spec.getUrl(), spec.getProps());
        } else {
            this.open(spec.getDriver(), spec.getUrl(), spec.getUser(), spec.getPassword());
        }
    }

    private void openJndi(ConnectionJndiSpec spec) {
        if (spec.getContext() != null) {
            this.openContext(spec.getContext(), spec.getDataSourceJndiName());
        } else {
            this.open(spec.getDataSourceJndiName());
        }
    }

    private void openContext(InitialContext context, String jndiName) {
        try {
            DataSource ds = (DataSource)context.lookup(jndiName);
            Connection connection = ds.getConnection();
            ConnectionsAccess.attach(this.name, connection, jndiName);
        }
        catch (Exception e) {
            throw new InitException("Failed to connect to JNDI name: " + jndiName, e);
        }
    }

    public void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean suppressWarning) {
        try {
            Connection connection = ConnectionsAccess.getConnection(this.name);
            if (connection == null) {
                throw new DBException("cannot close connection '" + this.name + "' because it is not available");
            }
            StatementCache.instance().cleanStatementCache(connection);
            connection.close();
            LogFilter.log(logger, "Closed connection: {}", (Object)connection);
        }
        catch (Exception e) {
            if (!suppressWarning) {
                logger.warn("Could not close connection! MUST INVESTIGATE POTENTIAL CONNECTION LEAK!", (Throwable)e);
            }
        }
        finally {
            ConnectionsAccess.detach(this.name);
        }
    }

    public Long count(String table) {
        String sql = "SELECT COUNT(*) FROM " + table;
        return Convert.toLong((Object)this.firstCell(sql, new Object[0]));
    }

    public Long count(String table, String query, Object ... params) {
        if (query.trim().equals("*")) {
            if (Util.empty((Object[])params)) {
                return this.count(table);
            }
            throw new IllegalArgumentException("cannot use '*' and parameters");
        }
        String sql = "SELECT COUNT(*) FROM " + table + " WHERE " + query;
        return Convert.toLong((Object)this.firstCell(sql, params));
    }

    public Object firstCell(String query, Object ... params) {
        Object object;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Object result = null;
            long start = System.currentTimeMillis();
            ps = this.connection().prepareStatement(query);
            this.setParameters(ps, params);
            rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getObject(1);
            }
            LogFilter.logQuery(logger, query, params, start);
            object = result;
        }
        catch (SQLException e) {
            try {
                throw new DBException(query, params, e);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(rs);
                Util.closeQuietly(ps);
                throw throwable;
            }
        }
        Util.closeQuietly((ResultSet)rs);
        Util.closeQuietly((Statement)ps);
        return object;
    }

    public List<Map> all(String query, Object ... params) {
        return this.findAll(query, params);
    }

    public List<Map> findAll(String query, Object ... params) {
        final ArrayList<Map> results = new ArrayList<Map>();
        long start = System.currentTimeMillis();
        this.find(query, params).with(new RowListenerAdapter(){

            @Override
            public void onNext(Map<String, Object> row) {
                results.add(row);
            }
        });
        LogFilter.logQuery(logger, query, params, start);
        return results;
    }

    public List firstColumn(String query, Object ... params) {
        ArrayList<Object> arrayList;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            long start = System.currentTimeMillis();
            ps = this.connection().prepareStatement(query);
            this.setParameters(ps, params);
            rs = ps.executeQuery();
            while (rs.next()) {
                results.add(rs.getObject(1));
            }
            LogFilter.logQuery(logger, query, params, start);
            arrayList = results;
        }
        catch (SQLException e) {
            try {
                throw new DBException(query, params, e);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(rs);
                Util.closeQuietly(ps);
                throw throwable;
            }
        }
        Util.closeQuietly((ResultSet)rs);
        Util.closeQuietly((Statement)ps);
        return arrayList;
    }

    public List<Map> all(String query) {
        return this.findAll(query);
    }

    public List<Map> findAll(String query) {
        final ArrayList<Map> results = new ArrayList<Map>();
        long start = System.currentTimeMillis();
        this.find(query, new Object[0]).with(new RowListenerAdapter(){

            @Override
            public void onNext(Map<String, Object> row) {
                results.add(row);
            }
        });
        LogFilter.logQuery(logger, query, null, start);
        return results;
    }

    public RowProcessor find(String query, Object ... params) {
        if (query.indexOf(63) == -1 && params.length != 0) {
            throw new IllegalArgumentException("you passed arguments, but the query does not have placeholders: (?)");
        }
        if (!SELECT_PATTERN.matcher(query).find()) {
            throw new IllegalArgumentException("query must be 'select' query");
        }
        try {
            PreparedStatement ps = this.createStreamingPreparedStatement(query);
            this.setParameters(ps, params);
            ResultSet rs = ps.executeQuery();
            return new RowProcessor(rs, ps);
        }
        catch (SQLException e) {
            throw new DBException(query, params, e);
        }
    }

    private PreparedStatement createStreamingPreparedStatement(String query) throws SQLException {
        PreparedStatement res;
        Connection conn = this.connection();
        if ("mysql".equalsIgnoreCase(conn.getMetaData().getDatabaseProductName())) {
            res = conn.prepareStatement(query, 1003, 1007);
            res.setFetchSize(Integer.MIN_VALUE);
        } else {
            res = conn.prepareStatement(query);
        }
        return res;
    }

    public void find(String sql, RowListener listener) {
        Statement s = null;
        ResultSet rs = null;
        try {
            s = this.createStreamingStatement();
            rs = s.executeQuery(sql);
            RowProcessor p = new RowProcessor(rs, s);
            p.with(listener);
        }
        catch (SQLException e) {
            try {
                throw new DBException(sql, null, e);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(rs);
                Util.closeQuietly((Statement)s);
                throw throwable;
            }
        }
        Util.closeQuietly((ResultSet)rs);
        Util.closeQuietly((Statement)s);
    }

    private Statement createStreamingStatement() throws SQLException {
        Statement res;
        Connection conn = this.connection();
        if ("mysql".equalsIgnoreCase(conn.getMetaData().getDatabaseProductName())) {
            res = conn.createStatement(1003, 1007);
            res.setFetchSize(Integer.MIN_VALUE);
        } else {
            res = conn.createStatement();
        }
        return res;
    }

    public int exec(String query) {
        long start = System.currentTimeMillis();
        Statement s = null;
        try {
            s = this.connection().createStatement();
            int count = s.executeUpdate(query);
            LogFilter.logQuery(logger, query, null, start);
            int n = count;
            return n;
        }
        catch (SQLException e) {
            this.logException("Query failed: " + query, e);
            throw new DBException(query, null, e);
        }
        finally {
            Util.closeQuietly((Statement)s);
        }
    }

    public int exec(String query, Object ... params) {
        int n;
        if (SELECT_PATTERN.matcher(query).find()) {
            throw new IllegalArgumentException("expected DML, but got select...");
        }
        if (query.indexOf(63) == -1) {
            throw new IllegalArgumentException("query must be parametrized");
        }
        long start = System.currentTimeMillis();
        PreparedStatement ps = null;
        try {
            ps = this.connection().prepareStatement(query);
            this.setParameters(ps, params);
            int count = ps.executeUpdate();
            LogFilter.logQuery(logger, query, params, start);
            n = count;
        }
        catch (SQLException e) {
            try {
                this.logException("Failed query: " + query, e);
                throw new DBException(query, params, e);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(ps);
                throw throwable;
            }
        }
        Util.closeQuietly((Statement)ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object execInsert(String query, String autoIncrementColumnName, Object ... params) {
        if (!INSERT_PATTERN.matcher(query).find()) {
            throw new IllegalArgumentException("this method is only for inserts");
        }
        long start = System.currentTimeMillis();
        PreparedStatement ps = null;
        try {
            Object object;
            Connection connection = this.connection();
            ps = StatementCache.instance().getPreparedStatement(connection, query);
            if (ps == null) {
                ps = connection.prepareStatement(query, new String[]{autoIncrementColumnName});
                StatementCache.instance().cache(connection, query, ps);
            }
            int index232 = 0;
            while (index232 < params.length) {
                Object param;
                if ((param = params[index232++]) instanceof byte[]) {
                    byte[] bytes = (byte[])param;
                    try {
                        Blob blob = connection.createBlob();
                        if (blob == null) {
                            ps.setBytes(index232, bytes);
                            continue;
                        }
                        blob.setBytes(1L, bytes);
                        ps.setBlob(index232, blob);
                    }
                    catch (AbstractMethodError e) {
                        ps.setObject(index232, param);
                    }
                    catch (SQLException e) {
                        ps.setObject(index232, param);
                    }
                    continue;
                }
                ps.setObject(index232, param);
            }
            if (ps.executeUpdate() != 1) {
                return null;
            }
            ResultSet rs = null;
            try {
                Object id;
                rs = ps.getGeneratedKeys();
                if (rs.next()) {
                    id = rs.getObject(1);
                    LogFilter.logQuery(logger, query, params, start);
                    object = id;
                    return object;
                }
                id = -1;
                return id;
            }
            catch (SQLException e) {
                logger.error("Failed to find out the auto-incremented value, returning -1, query: {}", (Object)query, (Object)e);
                object = -1;
                return object;
            }
            finally {
                Util.closeQuietly((ResultSet)rs);
            }
        }
        catch (SQLException e2) {
            throw new DBException(query, params, e2);
        }
    }

    private void logException(String message, Exception e) {
        if (logger.isErrorEnabled() && Convert.toBoolean((Object)System.getProperty("activejdbc.log_exception")).booleanValue()) {
            logger.error(message, (Throwable)e);
        }
    }

    public void openTransaction() {
        try {
            Connection c = ConnectionsAccess.getConnection(this.name);
            if (c == null) {
                throw new DBException("Cannot open transaction, connection '" + this.name + "' not available");
            }
            c.setAutoCommit(false);
            LogFilter.log(logger, "Transaction opened");
        }
        catch (SQLException ex) {
            throw new DBException(ex.getMessage(), ex);
        }
    }

    public void commitTransaction() {
        try {
            Connection c = ConnectionsAccess.getConnection(this.name);
            if (c == null) {
                throw new DBException("Cannot commit transaction, connection '" + this.name + "' not available");
            }
            c.commit();
            LogFilter.log(logger, "Transaction committed");
        }
        catch (SQLException ex) {
            throw new DBException(ex.getMessage(), ex);
        }
    }

    public void rollbackTransaction() {
        try {
            Connection c = ConnectionsAccess.getConnection(this.name);
            if (c == null) {
                throw new DBException("Cannot rollback transaction, connection '" + this.name + "' not available");
            }
            c.rollback();
            LogFilter.log(logger, "Transaction rolled back");
        }
        catch (SQLException ex) {
            throw new DBException(ex.getMessage(), ex);
        }
    }

    public Connection connection() {
        Connection connection = ConnectionsAccess.getConnection(this.name);
        if (connection == null) {
            throw new DBException("there is no connection '" + this.name + "' on this thread, are you sure you opened it?");
        }
        return connection;
    }

    public boolean hasConnection() {
        return null != ConnectionsAccess.getConnection(this.name);
    }

    public Connection getConnection() {
        return this.connection();
    }

    public static List<String> getCurrrentConnectionNames() {
        return new ArrayList<String>(ConnectionsAccess.getConnectionMap().keySet());
    }

    public static void closeAllConnections() {
        List<String> names = DB.getCurrrentConnectionNames();
        for (String name : names) {
            new DB(name).close();
        }
    }

    public static Map<String, Connection> connections() {
        return ConnectionsAccess.getConnectionMap();
    }

    public PreparedStatement startBatch(String parametrizedStatement) {
        try {
            return this.connection().prepareStatement(parametrizedStatement);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public void addBatch(PreparedStatement ps, Object ... params) {
        try {
            this.setParameters(ps, params);
            ps.addBatch();
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public void executeBatch(PreparedStatement ps) {
        try {
            ps.executeBatch();
            ps.clearParameters();
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    private void setParameters(PreparedStatement ps, Object ... params) throws SQLException {
        int index = 0;
        while (index < params.length) {
            Object param = params[index++];
            ps.setObject(index, param);
        }
    }
}

