/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.Registry;

public class ModelFinder {
    private static final Map<String, List<Class<? extends Model>>> modelClasses = new HashMap<String, List<Class<? extends Model>>>();
    private static final List<String> modelClassNames = new ArrayList<String>();

    protected static void findModels(String dbName) throws IOException, ClassNotFoundException {
        List<String> models = Registry.instance().getConfiguration().getModelNames(dbName);
        if (models != null && !models.isEmpty()) {
            for (String model : models) {
                ModelFinder.modelFound(model);
            }
        } else {
            throw new InitException("you are trying to work with models, but no models are found. Maybe you have no models in project, or you did not instrument the models. It is expected that you have a file activejdbc_models.properties on classpath");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<Class<? extends Model>> getModelsForDb(String dbName) throws IOException, ClassNotFoundException {
        List<String> list = modelClassNames;
        synchronized (list) {
            if (!modelClasses.containsKey(dbName)) {
                for (String className : modelClassNames) {
                    ModelFinder.registerModelClass(className);
                }
            }
            return modelClasses.get(dbName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modelFound(String modelClassName) {
        List<String> list = modelClassNames;
        synchronized (list) {
            if (!modelClassNames.contains(modelClassName)) {
                modelClassNames.add(modelClassName);
            }
        }
    }

    public static void registerModelClass(String className) throws IOException, ClassNotFoundException {
        Class<?> clazz = Class.forName(className);
        if (Model.class.isAssignableFrom(clazz) && clazz != null && !clazz.equals(Model.class)) {
            String dbName = MetaModel.getDbName(clazz);
            if (modelClasses.get(dbName) == null) {
                modelClasses.put(dbName, new ArrayList());
            }
            if (!modelClasses.get(dbName).contains(clazz)) {
                modelClasses.get(dbName).add(clazz);
            }
        }
    }
}

