/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.javalite.activejdbc.CallbackListener;
import org.javalite.activejdbc.CaseInsensitiveMap;
import org.javalite.activejdbc.conversion.Converter;
import org.javalite.activejdbc.conversion.DateToStringConverter;
import org.javalite.activejdbc.conversion.StringToSqlDateConverter;
import org.javalite.activejdbc.conversion.StringToTimestampConverter;
import org.javalite.activejdbc.validation.AttributePresenceValidator;
import org.javalite.activejdbc.validation.NumericValidationBuilder;
import org.javalite.activejdbc.validation.NumericValidator;
import org.javalite.activejdbc.validation.ValidationBuilder;
import org.javalite.activejdbc.validation.Validator;

class ModelRegistry {
    private final List<CallbackListener> callbacks = new ArrayList<CallbackListener>();
    private final Map<String, List<Converter>> attributeConverters = new CaseInsensitiveMap<List<Converter>>();
    private final List<Validator> validators = new ArrayList<Validator>();

    ModelRegistry() {
    }

    void callbackWith(CallbackListener ... listeners) {
        this.callbackWith(Arrays.asList(listeners));
    }

    void callbackWith(Collection<CallbackListener> callbacks) {
        this.callbacks.addAll(callbacks);
    }

    List<CallbackListener> callbacks() {
        return this.callbacks;
    }

    void dateFormat(String pattern, String ... attributes) {
        this.dateFormat(new SimpleDateFormat(pattern), attributes);
    }

    void dateFormat(DateFormat format, String ... attributes) {
        this.convertWith((Converter)new DateToStringConverter(format), attributes);
        this.convertWith((Converter)new StringToSqlDateConverter(format), attributes);
    }

    void timestampFormat(String pattern, String ... attributes) {
        this.timestampFormat(new SimpleDateFormat(pattern), attributes);
    }

    void timestampFormat(DateFormat format, String ... attributes) {
        this.convertWith((Converter)new DateToStringConverter(format), attributes);
        this.convertWith((Converter)new StringToTimestampConverter(format), attributes);
    }

    void convertWith(Converter converter, String ... attributes) {
        for (String attribute : attributes) {
            this.convertWith(converter, attribute);
        }
    }

    void convertWith(Converter converter, String attribute) {
        List<Converter> list = this.attributeConverters.get(attribute);
        if (list == null) {
            list = new ArrayList<Converter>();
            this.attributeConverters.put(attribute, list);
        }
        list.add(converter);
    }

    <S, T> Converter<S, T> converterForClass(String attribute, Class<S> sourceClass, Class<T> destinationClass) {
        List<Converter> list = this.attributeConverters.get(attribute);
        if (list != null) {
            for (Converter converter : list) {
                if (!converter.canConvert(sourceClass, destinationClass)) continue;
                return converter;
            }
        }
        return null;
    }

    <T> Converter<Object, T> converterForValue(String attribute, Object value, Class<T> destinationClass) {
        return this.converterForClass(attribute, value != null ? value.getClass() : Object.class, destinationClass);
    }

    ValidationBuilder validateWith(Validator validator) {
        this.validators.add(validator);
        return new ValidationBuilder<Validator>(validator);
    }

    ValidationBuilder validateWith(List<Validator> list) {
        this.validators.addAll(list);
        return new ValidationBuilder<List<Validator>>(list);
    }

    NumericValidationBuilder validateNumericalityOf(String ... attributes) {
        ArrayList<NumericValidator> list = new ArrayList<NumericValidator>();
        for (String attribute : attributes) {
            NumericValidator validator = new NumericValidator(attribute);
            list.add(validator);
            this.validators.add(validator);
        }
        return new NumericValidationBuilder((List<NumericValidator>)list);
    }

    ValidationBuilder validatePresenceOf(String ... attributes) {
        ArrayList<Validator> list = new ArrayList<Validator>();
        for (String attribute : attributes) {
            list.add(new AttributePresenceValidator(attribute));
        }
        return this.validateWith(list);
    }

    void removeValidator(Validator validator) {
        this.validators.remove(validator);
    }

    List<Validator> validators() {
        return this.validators;
    }
}

