/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.javalite.activejdbc.DB;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.InternalException;
import org.javalite.activejdbc.LazyList;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.Registry;
import org.javalite.activejdbc.cache.QueryCache;
import org.javalite.common.Convert;

public class Paginator<T extends Model>
implements Serializable {
    static final Pattern FROM_PATTERN = Pattern.compile("\\s+FROM\\s+", 10);
    private final int pageSize;
    private final String query;
    private String orderBys;
    private final Object[] params;
    private final MetaModel metaModel;
    private int currentPage;
    private final boolean fullQuery;
    private final String countQuery;
    private boolean suppressCounts = false;
    private Long count = 0L;

    public Paginator(Class<? extends T> modelClass, int pageSize, String query, Object ... params) {
        this(modelClass, pageSize, false, query, params);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Paginator(Class<? extends T> modelClass, int pageSize, boolean suppressCounts, String query, Object ... params) {
        this.suppressCounts = suppressCounts;
        try {
            Class.forName(modelClass.getName());
        }
        catch (ClassNotFoundException e) {
            throw new InitException(e);
        }
        this.pageSize = pageSize;
        this.query = query;
        this.params = params;
        String tableName = Registry.instance().getTableName(modelClass);
        this.metaModel = Registry.instance().getMetaModel(tableName);
        this.fullQuery = DB.SELECT_PATTERN.matcher(query).find();
        if (this.fullQuery) {
            Matcher m = FROM_PATTERN.matcher(query);
            if (!m.find()) {
                throw new IllegalArgumentException("SELECT query without FROM");
            }
            this.countQuery = this.metaModel.getDialect().selectCount(query.substring(m.end()));
            return;
        } else if (query.equals("*")) {
            if (params.length != 0) throw new IllegalArgumentException("cannot provide parameters with query: '*'");
            this.countQuery = this.metaModel.getDialect().selectCount(tableName);
            return;
        } else {
            this.countQuery = this.metaModel.getDialect().selectCount(tableName, query);
        }
    }

    public Paginator orderBy(String orderBys) {
        this.orderBys = orderBys;
        return this;
    }

    public LazyList<T> getPage(int pageNumber) {
        if (pageNumber < 1) {
            throw new IllegalArgumentException("minimum page index == 1");
        }
        try {
            LazyList list = this.find(this.query, this.params).offset((pageNumber - 1) * this.pageSize).limit(this.pageSize);
            if (this.orderBys != null) {
                list.orderBy(this.orderBys);
            }
            this.currentPage = pageNumber;
            return list;
        }
        catch (Exception mustNeverHappen) {
            throw new InternalException(mustNeverHappen);
        }
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public boolean getPrevious() {
        return this.hasPrevious();
    }

    public boolean hasPrevious() {
        return this.currentPage > 1 && (long)this.currentPage <= this.pageCount();
    }

    public boolean getNext() {
        return this.hasNext();
    }

    public boolean hasNext() {
        return (long)this.currentPage < this.pageCount();
    }

    public long pageCount() {
        try {
            long results = this.getCount();
            long fullPages = results / (long)this.pageSize;
            return results % (long)this.pageSize == 0L ? fullPages : fullPages + 1L;
        }
        catch (Exception mustNeverHappen) {
            throw new InternalException(mustNeverHappen);
        }
    }

    private LazyList<T> find(String query, Object ... params) {
        if (query.equals("*")) {
            if (params.length == 0) {
                return this.findAll();
            }
            throw new IllegalArgumentException("cannot provide parameters with query: '*'");
        }
        return this.fullQuery ? new LazyList(true, this.metaModel, this.query, params) : new LazyList(query, this.metaModel, params);
    }

    private LazyList<T> findAll() {
        return new LazyList(null, this.metaModel, new Object[0]);
    }

    public Long getCount() {
        if (this.count == 0L || !this.suppressCounts) {
            if (this.metaModel.cached()) {
                this.count = (Long)QueryCache.instance().getItem(this.metaModel.getTableName(), this.countQuery, this.params);
                if (this.count == null || this.count == 0L) {
                    this.count = this.doCount();
                    QueryCache.instance().addItem(this.metaModel.getTableName(), this.countQuery, this.params, this.count);
                }
            } else {
                this.count = this.doCount();
            }
            return this.count;
        }
        return this.count;
    }

    private Long doCount() {
        return Convert.toLong((Object)new DB(this.metaModel.getDbName()).firstCell(this.countQuery, this.params));
    }
}

