/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javalite.activejdbc.CaseInsensitiveMap;
import org.javalite.activejdbc.ColumnMetadata;
import org.javalite.activejdbc.Configuration;
import org.javalite.activejdbc.ConnectionsAccess;
import org.javalite.activejdbc.DBException;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.LogFilter;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.MetaModels;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.ModelFinder;
import org.javalite.activejdbc.ModelRegistry;
import org.javalite.activejdbc.annotations.BelongsTo;
import org.javalite.activejdbc.annotations.BelongsToParents;
import org.javalite.activejdbc.annotations.BelongsToPolymorphic;
import org.javalite.activejdbc.annotations.Many2Many;
import org.javalite.activejdbc.associations.BelongsToAssociation;
import org.javalite.activejdbc.associations.BelongsToPolymorphicAssociation;
import org.javalite.activejdbc.associations.Many2ManyAssociation;
import org.javalite.activejdbc.associations.OneToManyAssociation;
import org.javalite.activejdbc.associations.OneToManyPolymorphicAssociation;
import org.javalite.activejdbc.cache.CacheManager;
import org.javalite.activejdbc.cache.QueryCache;
import org.javalite.activejdbc.statistics.StatisticsQueue;
import org.javalite.common.Inflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Registry {
    INSTANCE;

    private static final Logger logger;
    private final MetaModels metaModels = new MetaModels();
    private final Map<Class, ModelRegistry> modelRegistries = new HashMap<Class, ModelRegistry>();
    private final Configuration configuration = new Configuration();
    private final StatisticsQueue statisticsQueue;
    private final Set<String> initedDbs = new HashSet<String>();

    private Registry() {
        this.statisticsQueue = this.configuration.collectStatistics() ? new StatisticsQueue(this.configuration.collectStatisticsOnHold()) : null;
    }

    @Deprecated
    public boolean initialized() {
        return !this.initedDbs.isEmpty();
    }

    public static Registry instance() {
        return INSTANCE;
    }

    public StatisticsQueue getStatisticsQueue() {
        if (this.statisticsQueue == null) {
            throw new InitException("cannot collect statistics if this was not configured in activejdbc.properties file. Add 'collectStatistics = true' to it.");
        }
        return this.statisticsQueue;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public static CacheManager cacheManager() {
        return QueryCache.instance().getCacheManager();
    }

    public MetaModel getMetaModel(String table) {
        return this.metaModels.getMetaModel(table);
    }

    public MetaModel getMetaModel(Class<? extends Model> modelClass) {
        String dbName = MetaModel.getDbName(modelClass);
        this.init(dbName);
        return this.metaModels.getMetaModel(modelClass);
    }

    ModelRegistry modelRegistryOf(Class<? extends Model> modelClass) {
        ModelRegistry registry = this.modelRegistries.get(modelClass);
        if (registry == null) {
            registry = new ModelRegistry();
            this.modelRegistries.put(modelClass, registry);
        }
        return registry;
    }

    synchronized void init(String dbName) {
        if (this.initedDbs.contains(dbName)) {
            return;
        }
        this.initedDbs.add(dbName);
        try {
            String[] tables;
            ModelFinder.findModels(dbName);
            Connection c = ConnectionsAccess.getConnection(dbName);
            if (c == null) {
                throw new DBException("Failed to retrieve metadata from DB, connection: '" + dbName + "' is not available");
            }
            DatabaseMetaData databaseMetaData = c.getMetaData();
            String databaseProductName = c.getMetaData().getDatabaseProductName();
            List<Class<? extends Model>> modelClasses = ModelFinder.getModelsForDb(dbName);
            this.registerModels(dbName, modelClasses, databaseProductName);
            for (String table : tables = this.metaModels.getTableNames(dbName)) {
                Map<String, ColumnMetadata> metaParams = this.fetchMetaParams(databaseMetaData, databaseProductName, table);
                this.registerColumnMetadata(table, metaParams);
            }
            this.processOverrides(modelClasses);
            for (String table : tables) {
                this.discoverAssociationsFor(table, dbName);
            }
        }
        catch (Exception e) {
            this.initedDbs.remove(dbName);
            if (e instanceof InitException) {
                throw (InitException)e;
            }
            if (e instanceof DBException) {
                throw (DBException)e;
            }
            throw new InitException(e);
        }
    }

    private Map<String, ColumnMetadata> fetchMetaParams(DatabaseMetaData databaseMetaData, String databaseProductName, String table) throws SQLException {
        String tableName;
        String[] names = table.split("\\.", 3);
        String schema = null;
        switch (names.length) {
            case 1: {
                tableName = names[0];
                break;
            }
            case 2: {
                schema = names[0];
                tableName = names[1];
                if (!schema.isEmpty() && !tableName.isEmpty()) break;
                throw new DBException("invalid table name : " + table);
            }
            default: {
                throw new DBException("invalid table name: " + table);
            }
        }
        ResultSet rs = databaseMetaData.getColumns(null, schema, tableName, null);
        String dbProduct = databaseMetaData.getDatabaseProductName().toLowerCase();
        Map<String, ColumnMetadata> columns = this.getColumns(rs, dbProduct);
        rs.close();
        if (columns.isEmpty()) {
            rs = databaseMetaData.getColumns(null, schema, tableName.toUpperCase(), null);
            dbProduct = databaseProductName.toLowerCase();
            columns = this.getColumns(rs, dbProduct);
            rs.close();
        }
        if (columns.isEmpty()) {
            rs = databaseMetaData.getColumns(null, schema, tableName.toLowerCase(), null);
            columns = this.getColumns(rs, dbProduct);
            rs.close();
        }
        if (columns.size() > 0) {
            LogFilter.log(logger, "Fetched metadata for table: {}", (Object)table);
        } else {
            logger.warn("Failed to retrieve metadata for table: '{}'. Are you sure this table exists? For some databases table names are case sensitive.", (Object)table);
        }
        return columns;
    }

    private void registerModels(String dbName, List<Class<? extends Model>> modelClasses, String dbType) {
        for (Class<? extends Model> modelClass : modelClasses) {
            MetaModel mm = new MetaModel(dbName, modelClass, dbType);
            this.metaModels.addMetaModel(mm, modelClass);
            LogFilter.log(logger, "Registered model: {}", modelClass);
        }
    }

    private void processOverrides(List<Class<? extends Model>> models) {
        for (Class<? extends Model> modelClass : models) {
            BelongsToPolymorphic belongsToPolymorphic;
            Many2Many many2manyAnnotation;
            BelongsTo belongsToAnnotation = modelClass.getAnnotation(BelongsTo.class);
            this.processOverridesBelongsTo(modelClass, belongsToAnnotation);
            BelongsToParents belongsToParentAnnotation = modelClass.getAnnotation(BelongsToParents.class);
            if (belongsToParentAnnotation != null) {
                for (BelongsTo belongsTo : belongsToParentAnnotation.value()) {
                    this.processOverridesBelongsTo(modelClass, belongsTo);
                }
            }
            if ((many2manyAnnotation = modelClass.getAnnotation(Many2Many.class)) != null) {
                String otherPk;
                String thisPk;
                Class<? extends Model> otherClass = many2manyAnnotation.other();
                String source = this.getTableName(modelClass);
                String target = this.getTableName(otherClass);
                String join = many2manyAnnotation.join();
                String sourceFKName = many2manyAnnotation.sourceFKName();
                String targetFKName = many2manyAnnotation.targetFKName();
                try {
                    Method m = modelClass.getMethod("getMetaModel", new Class[0]);
                    MetaModel mm = (MetaModel)m.invoke(modelClass, new Object[0]);
                    thisPk = mm.getIdName();
                    m = otherClass.getMethod("getMetaModel", new Class[0]);
                    mm = (MetaModel)m.invoke(otherClass, new Object[0]);
                    otherPk = mm.getIdName();
                }
                catch (Exception e) {
                    throw new InitException("failed to determine PK name in many to many relationship", e);
                }
                Many2ManyAssociation many2many1 = new Many2ManyAssociation(source, target, join, sourceFKName, targetFKName, otherPk);
                this.metaModels.getMetaModel(source).addAssociation(many2many1);
                Many2ManyAssociation many2many2 = new Many2ManyAssociation(target, source, join, targetFKName, sourceFKName, thisPk);
                this.metaModels.getMetaModel(target).addAssociation(many2many2);
            }
            if ((belongsToPolymorphic = modelClass.getAnnotation(BelongsToPolymorphic.class)) == null) continue;
            Class<? extends Model>[] parentClasses = belongsToPolymorphic.parents();
            String[] typeLabels = belongsToPolymorphic.typeLabels();
            if (typeLabels.length > 0 && typeLabels.length != parentClasses.length) {
                throw new InitException("must provide all type labels for polymorphic associations");
            }
            int parentClassesLength = parentClasses.length;
            for (int i = 0; i < parentClassesLength; ++i) {
                Class<? extends Model> parentClass = parentClasses[i];
                String typeLabel = typeLabels.length > 0 ? typeLabels[i] : parentClass.getName();
                BelongsToPolymorphicAssociation belongsToPolymorphicAssociation = new BelongsToPolymorphicAssociation(this.getTableName(modelClass), this.getTableName(parentClass), typeLabel, parentClass.getName());
                this.metaModels.getMetaModel(modelClass).addAssociation(belongsToPolymorphicAssociation);
                OneToManyPolymorphicAssociation oneToManyPolymorphicAssociation = new OneToManyPolymorphicAssociation(this.getTableName(parentClass), this.getTableName(modelClass), typeLabel);
                this.metaModels.getMetaModel(parentClass).addAssociation(oneToManyPolymorphicAssociation);
            }
        }
    }

    private void processOverridesBelongsTo(Class<? extends Model> modelClass, BelongsTo belongsToAnnotation) {
        if (belongsToAnnotation != null) {
            Class<? extends Model> parentClass = belongsToAnnotation.parent();
            String foreignKeyName = belongsToAnnotation.foreignKeyName();
            OneToManyAssociation hasMany = new OneToManyAssociation(this.getTableName(parentClass), this.getTableName(modelClass), foreignKeyName);
            BelongsToAssociation belongsTo = new BelongsToAssociation(this.getTableName(modelClass), this.getTableName(parentClass), foreignKeyName);
            this.metaModels.getMetaModel(parentClass).addAssociation(hasMany);
            this.metaModels.getMetaModel(modelClass).addAssociation(belongsTo);
        }
    }

    private Map<String, ColumnMetadata> getColumns(ResultSet rs, String dbProduct) throws SQLException {
        CaseInsensitiveMap<ColumnMetadata> columns = new CaseInsensitiveMap<ColumnMetadata>();
        while (rs.next()) {
            if ("h2".equals(dbProduct) && "INFORMATION_SCHEMA".equals(rs.getString("TABLE_SCHEM"))) continue;
            ColumnMetadata cm = new ColumnMetadata(rs.getString("COLUMN_NAME"), rs.getString("TYPE_NAME"), rs.getInt("COLUMN_SIZE"));
            columns.put(cm.getColumnName(), cm);
        }
        return columns;
    }

    private void discoverAssociationsFor(String source, String dbName) {
        this.discoverOne2ManyAssociationsFor(source, dbName);
        this.discoverMany2ManyAssociationsFor(source, dbName);
    }

    private void discoverMany2ManyAssociationsFor(String source, String dbName) {
        for (String join : this.metaModels.getTableNames(dbName)) {
            String other = Inflector.getOtherName((String)source, (String)join);
            if (other == null || this.getMetaModel(other) == null || !this.hasForeignKeys(join, source, other)) continue;
            Many2ManyAssociation associationSource = new Many2ManyAssociation(source, other, join, this.getMetaModel(source).getFKName(), this.getMetaModel(other).getFKName());
            this.getMetaModel(source).addAssociation(associationSource);
        }
    }

    private boolean hasForeignKeys(String join, String source, String other) {
        String sourceFKName = this.getMetaModel(source).getFKName();
        String otherFKName = this.getMetaModel(other).getFKName();
        MetaModel joinMM = this.getMetaModel(join);
        return joinMM.hasAttribute(sourceFKName) && joinMM.hasAttribute(otherFKName);
    }

    private void discoverOne2ManyAssociationsFor(String source, String dbName) {
        MetaModel sourceMM = this.getMetaModel(source);
        for (String target : this.metaModels.getTableNames(dbName)) {
            MetaModel targetMM = this.getMetaModel(target);
            String sourceFKName = this.getMetaModel(source).getFKName();
            if (targetMM == sourceMM || !targetMM.hasAttribute(sourceFKName)) continue;
            targetMM.addAssociation(new BelongsToAssociation(target, source, sourceFKName));
            sourceMM.addAssociation(new OneToManyAssociation(source, target, sourceFKName));
        }
    }

    protected Class<? extends Model> getModelClass(String table, boolean suppressException) {
        Class<? extends Model> modelClass = this.metaModels.getModelClass(table);
        if (modelClass == null && !suppressException) {
            throw new InitException("failed to locate meta model for: " + table + ", are you sure this is correct table name?");
        }
        return modelClass;
    }

    protected String getTableName(Class<? extends Model> modelClass) {
        this.init(MetaModel.getDbName(modelClass));
        String tableName = this.metaModels.getTableName(modelClass);
        if (tableName == null) {
            throw new DBException("failed to find metamodel for " + modelClass + ". Are you sure that a corresponding table  exists in DB?");
        }
        return tableName;
    }

    protected List<String> getEdges(String join) {
        return this.metaModels.getEdges(join);
    }

    private void registerColumnMetadata(String table, Map<String, ColumnMetadata> metaParams) {
        this.metaModels.setColumnMetadata(table, metaParams);
    }

    static {
        logger = LoggerFactory.getLogger(Registry.class);
    }
}

