/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.cache;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import net.sf.ehcache.ObjectExistsException;
import org.javalite.activejdbc.cache.CacheEvent;
import org.javalite.activejdbc.cache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EHCacheManager
extends CacheManager {
    private static final Logger logger = LoggerFactory.getLogger(EHCacheManager.class);
    private final net.sf.ehcache.CacheManager cacheManager = net.sf.ehcache.CacheManager.create();

    @Override
    public Object getCache(String group, String key) {
        try {
            this.createIfMissing(group);
            Cache c = this.cacheManager.getCache(group);
            return c.get((Serializable)((Object)key)) == null ? null : c.get((Serializable)((Object)key)).getObjectValue();
        }
        catch (Exception e) {
            logger.warn("{}", (Object)e, (Object)e);
            return null;
        }
    }

    private void createIfMissing(String group) {
        if (this.cacheManager.getCache(group) == null) {
            try {
                this.cacheManager.addCache(group);
            }
            catch (ObjectExistsException objectExistsException) {
                // empty catch block
            }
        }
    }

    @Override
    public void addCache(String group, String key, Object cache) {
        this.createIfMissing(group);
        this.cacheManager.getCache(group).put(new Element((Object)key, cache));
    }

    @Override
    public void doFlush(CacheEvent event) {
        if (event.getType().equals((Object)CacheEvent.CacheEventType.ALL)) {
            this.cacheManager.removalAll();
        } else if (event.getType().equals((Object)CacheEvent.CacheEventType.GROUP)) {
            this.cacheManager.removeCache(event.getGroup());
        }
    }
}

