/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.dialects;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.javalite.activejdbc.DBException;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.dialects.DefaultDialect;
import org.javalite.common.Util;

public class MSSQLDialect
extends DefaultDialect {
    protected final Pattern selectPattern = Pattern.compile("^\\s*SELECT\\s*", 10);

    @Override
    public String formSelect(String tableName, String subQuery, List<String> orderBys, long limit, long offset) {
        boolean needOffset;
        boolean needLimit = limit != -1L;
        boolean bl = needOffset = offset != -1L;
        if (needOffset && (orderBys == null || orderBys.isEmpty())) {
            throw new DBException("MSSQL offset queries require an order by column.");
        }
        boolean keepSelect = false;
        StringBuilder fullQuery = new StringBuilder();
        if (needOffset) {
            fullQuery.append("SELECT sq.* FROM (SELECT ROW_NUMBER() OVER (ORDER BY ");
            Util.join((StringBuilder)fullQuery, orderBys, (String)", ");
            fullQuery.append(") AS rownumber,");
        } else if (needLimit) {
            fullQuery.append("SELECT TOP ").append(limit);
        } else {
            keepSelect = true;
        }
        if (tableName == null) {
            if (keepSelect) {
                fullQuery.append(subQuery);
            } else {
                Matcher m = this.selectPattern.matcher(subQuery);
                if (m.find()) {
                    fullQuery.append(' ').append(subQuery.substring(m.end()));
                } else {
                    fullQuery.append(subQuery);
                }
            }
        } else {
            if (keepSelect) {
                fullQuery.append("SELECT");
            }
            fullQuery.append(" * FROM ").append(tableName);
            this.appendSubQuery(fullQuery, subQuery);
        }
        if (needOffset) {
            if (needLimit) {
                fullQuery.append(") AS sq WHERE rownumber BETWEEN ").append(offset + 1L).append(" AND ").append(limit + offset);
            } else {
                fullQuery.append(") AS sq WHERE rownumber >= ").append(offset + 1L);
            }
        } else {
            this.appendOrderBy(fullQuery, orderBys);
        }
        return fullQuery.toString();
    }

    @Override
    public Object overrideDriverTypeConversion(MetaModel mm, String attributeName, Object value) {
        if (value instanceof String) {
            String typeName = mm.getColumnMetadata().get(attributeName).getTypeName();
            if ("date".equalsIgnoreCase(typeName)) {
                return Date.valueOf((String)value);
            }
            if ("datetime2".equalsIgnoreCase(typeName)) {
                return Timestamp.valueOf((String)value);
            }
        }
        return value;
    }

    @Override
    protected void appendDate(StringBuilder query, Date value) {
        query.append("CONVERT(date, '").append(value.toString()).append("')");
    }

    @Override
    protected void appendTime(StringBuilder query, Time value) {
        query.append("CONVERT(time, '").append(value.toString()).append("')");
    }

    @Override
    protected void appendTimestamp(StringBuilder query, Timestamp value) {
        query.append("CONVERT(datetime2, '").append(value.toString()).append("')");
    }
}

