/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.dialects;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.dialects.DefaultDialect;

public class OracleDialect
extends DefaultDialect {
    @Override
    public String formSelect(String tableName, String subQuery, List<String> orderBys, long limit, long offset) {
        boolean needLimit = limit != -1L;
        boolean needOffset = offset != -1L;
        StringBuilder fullQuery = new StringBuilder();
        if (needOffset) {
            fullQuery.append("SELECT * FROM (SELECT t2.*, ROWNUM AS oracle_row_number FROM (");
        } else if (needLimit) {
            fullQuery.append("SELECT * FROM (SELECT t2.* FROM (");
        }
        this.appendSelect(fullQuery, tableName, needLimit || needOffset ? "t" : null, subQuery, orderBys);
        if (needOffset) {
            fullQuery.append(") t2) WHERE oracle_row_number >= ").append(offset + 1L);
            if (needLimit) {
                fullQuery.append(" AND ROWNUM <= ").append(limit);
            }
        } else if (needLimit) {
            fullQuery.append(") t2) WHERE ROWNUM <= ").append(limit);
        }
        return fullQuery.toString();
    }

    @Override
    protected void appendEmptyRow(MetaModel metaModel, StringBuilder query) {
        query.append('(').append(metaModel.getIdName()).append(") VALUES (").append(metaModel.getIdGeneratorCode() != null ? metaModel.getIdGeneratorCode() : "NULL").append(')');
    }

    @Override
    protected void appendTime(StringBuilder query, Time value) {
        this.appendTimestamp(query, new Timestamp(value.getTime()));
    }
}

