/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.dialects;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.dialects.PostgreSQLDialect;
import org.javalite.common.Convert;

public class SQLiteDialect
extends PostgreSQLDialect {
    @Override
    public String formSelect(String tableName, String subQuery, List<String> orderBys, long limit, long offset) {
        if (limit == -1L && offset != -1L) {
            throw new IllegalArgumentException("SQLite does not support OFFSET without LIMIT. OFFSET is a parameter of LIMIT function");
        }
        return super.formSelect(tableName, subQuery, orderBys, limit, offset);
    }

    @Override
    public Object overrideDriverTypeConversion(MetaModel mm, String attributeName, Object value) {
        if (value instanceof String || value instanceof Number) {
            String typeName = mm.getColumnMetadata().get(attributeName).getTypeName();
            if ("DATE".equalsIgnoreCase(typeName)) {
                return Convert.toSqlDate((Object)value);
            }
            if ("DATETIME".equalsIgnoreCase(typeName)) {
                return Convert.toTimestamp((Object)value);
            }
            if ("TIME".equalsIgnoreCase(typeName)) {
                return Convert.toTime((Object)value);
            }
        }
        return value;
    }

    @Override
    protected void appendDate(StringBuilder query, Date value) {
        query.append("date('").append(value.toString()).append("')");
    }

    @Override
    protected void appendTime(StringBuilder query, Time value) {
        query.append("time('").append(value.toString()).append("')");
    }

    @Override
    protected void appendTimestamp(StringBuilder query, Timestamp value) {
        query.append("datetime('").append(value.toString()).append("')");
    }
}

