/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.validation;

import java.text.NumberFormat;
import java.text.ParsePosition;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.validation.ValidatorAdapter;
import org.javalite.common.Convert;

public class NumericValidator
extends ValidatorAdapter {
    private final String attribute;
    private Double min = null;
    private Double max = null;
    private boolean allowNull = false;
    private boolean onlyInteger = false;
    private boolean convertNullIfEmpty = false;

    public NumericValidator(String attribute) {
        this.attribute = attribute;
        this.setMessage("value is not a number");
    }

    @Override
    public void validate(Model m) {
        Object value = m.get(this.attribute);
        if (!this.present(value, m)) {
            return;
        }
        if (this.convertNullIfEmpty && "".equals(value)) {
            m.set(this.attribute, null);
            value = null;
        }
        if (value == null && this.allowNull) {
            return;
        }
        if (!(value instanceof Number)) {
            if (value != null) {
                ParsePosition pp = new ParsePosition(0);
                String input = value.toString();
                NumberFormat nf = NumberFormat.getInstance();
                nf.setParseIntegerOnly(this.onlyInteger);
                nf.parse(input, pp);
                if (pp.getIndex() != input.length()) {
                    m.addValidator(this, this.attribute);
                }
            } else {
                m.addValidator(this, this.attribute);
            }
        }
        if (this.min != null) {
            this.validateMin(Convert.toDouble((Object)value), m);
        }
        if (this.max != null) {
            this.validateMax(Convert.toDouble((Object)value), m);
        }
        if (this.onlyInteger) {
            this.validateIntegerOnly(value, m);
        }
    }

    private void validateMin(Double value, Model m) {
        if (value <= this.min) {
            m.addValidator(this, this.attribute);
        }
    }

    private boolean present(Object value, Model m) {
        if (this.allowNull) {
            return true;
        }
        if (value == null) {
            this.setMessage("value is missing");
            m.addValidator(this, this.attribute);
            return false;
        }
        return true;
    }

    private void validateIntegerOnly(Object value, Model m) {
        try {
            Integer.valueOf(value.toString());
        }
        catch (NumberFormatException e) {
            m.addValidator(this, this.attribute);
        }
    }

    private void validateMax(Double value, Model m) {
        if (value >= this.max) {
            m.addValidator(this, this.attribute);
        }
    }

    public void setMin(Double min) {
        this.min = min;
    }

    public void setMax(Double max) {
        this.max = max;
    }

    public void setAllowNull(Boolean allowNull) {
        this.allowNull = allowNull;
    }

    public void setOnlyInteger(boolean onlyInteger) {
        this.onlyInteger = onlyInteger;
    }

    @Deprecated
    public void convertNullIfEmpty(boolean convertNullIfEmpty) {
        this.convertNullIfEmpty = convertNullIfEmpty;
    }
}

