/*
 * Decompiled with CFR 0.152.
 */
package ru.yole.jkid.deserialization;

import java.io.Reader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.yole.jkid.deserialization.JsonObject;
import ru.yole.jkid.deserialization.Lexer;
import ru.yole.jkid.deserialization.MalformedJSONException;
import ru.yole.jkid.deserialization.Token;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0006\u0010\u0010\u001a\u00020\fJ\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u000e2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J \u0010\u001b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lru/yole/jkid/deserialization/Parser;", "", "reader", "Ljava/io/Reader;", "rootObject", "Lru/yole/jkid/deserialization/JsonObject;", "(Ljava/io/Reader;Lru/yole/jkid/deserialization/JsonObject;)V", "lexer", "Lru/yole/jkid/deserialization/Lexer;", "getRootObject", "()Lru/yole/jkid/deserialization/JsonObject;", "expect", "", "token", "Lru/yole/jkid/deserialization/Token;", "nextToken", "parse", "parseArrayBody", "currentObject", "propName", "", "parseCommaSeparated", "stopToken", "body", "Lkotlin/Function1;", "parseObjectBody", "JsonObject", "parsePropertyValue", "build"})
public final class Parser {
    private final Lexer lexer;
    @NotNull
    private final JsonObject rootObject;

    public final void parse() {
        this.expect(Token.LBRACE.INSTANCE);
        this.parseObjectBody(this.rootObject);
        if (this.lexer.nextToken() != null) {
            throw (Throwable)new IllegalArgumentException("Too many tokens");
        }
    }

    private final void parseObjectBody(JsonObject JsonObject2) {
        this.parseCommaSeparated(Token.RBRACE.INSTANCE, (Function1<? super Token, Unit>)((Function1)new Function1<Token, Unit>(this, JsonObject2){
            final /* synthetic */ Parser this$0;
            final /* synthetic */ JsonObject $JsonObject;

            public final void invoke(@NotNull Token token) {
                Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
                if (!(token instanceof Token.StringValue)) {
                    throw (Throwable)new MalformedJSONException("Unexpected token " + token);
                }
                String propName = ((Token.StringValue)token).getValue();
                Parser.access$expect(this.this$0, Token.COLON.INSTANCE);
                Parser.access$parsePropertyValue(this.this$0, this.$JsonObject, propName, Parser.access$nextToken(this.this$0));
            }
            {
                this.this$0 = parser;
                this.$JsonObject = jsonObject;
                super(1);
            }
        }));
    }

    private final void parseArrayBody(JsonObject currentObject, String propName) {
        this.parseCommaSeparated(Token.RBRACKET.INSTANCE, (Function1<? super Token, Unit>)((Function1)new Function1<Token, Unit>(this, currentObject, propName){
            final /* synthetic */ Parser this$0;
            final /* synthetic */ JsonObject $currentObject;
            final /* synthetic */ String $propName;

            public final void invoke(@NotNull Token token) {
                Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
                Parser.access$parsePropertyValue(this.this$0, this.$currentObject, this.$propName, token);
            }
            {
                this.this$0 = parser;
                this.$currentObject = jsonObject;
                this.$propName = string;
                super(1);
            }
        }));
    }

    private final void parseCommaSeparated(Token stopToken, Function1<? super Token, Unit> body) {
        boolean expectComma = false;
        Token token;
        while (!Intrinsics.areEqual((Object)(token = this.nextToken()), (Object)stopToken)) {
            if (expectComma) {
                if (Intrinsics.areEqual((Object)token, (Object)Token.COMMA.INSTANCE) ^ true) {
                    throw (Throwable)new MalformedJSONException("Expected comma");
                }
                token = this.nextToken();
            }
            body.invoke((Object)token);
            expectComma = true;
        }
        return;
    }

    private final void parsePropertyValue(JsonObject currentObject, String propName, Token token) {
        Token token2 = token;
        if (token2 instanceof Token.ValueToken) {
            currentObject.setSimpleProperty(propName, ((Token.ValueToken)token).getValue());
        } else if (Intrinsics.areEqual((Object)token2, (Object)Token.LBRACE.INSTANCE)) {
            JsonObject childObj = currentObject.createObject(propName);
            this.parseObjectBody(childObj);
        } else if (Intrinsics.areEqual((Object)token2, (Object)Token.LBRACKET.INSTANCE)) {
            JsonObject childObj = currentObject.createArray(propName);
            this.parseArrayBody(childObj, propName);
        } else {
            throw (Throwable)new MalformedJSONException("Unexpected token " + token);
        }
    }

    private final void expect(Token token) {
        if (Intrinsics.areEqual((Object)this.lexer.nextToken(), (Object)token) ^ true) {
            throw (Throwable)new IllegalArgumentException("" + token + " expected");
        }
    }

    private final Token nextToken() {
        Token token = this.lexer.nextToken();
        if (token == null) {
            throw (Throwable)new IllegalArgumentException("Premature end of data");
        }
        return token;
    }

    @NotNull
    public final JsonObject getRootObject() {
        return this.rootObject;
    }

    public Parser(@NotNull Reader reader, @NotNull JsonObject rootObject) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull((Object)rootObject, (String)"rootObject");
        this.rootObject = rootObject;
        this.lexer = new Lexer(reader);
    }

    public static final /* synthetic */ void access$expect(Parser $this, @NotNull Token token) {
        $this.expect(token);
    }

    public static final /* synthetic */ void access$parsePropertyValue(Parser $this, @NotNull JsonObject currentObject, @NotNull String propName, @NotNull Token token) {
        $this.parsePropertyValue(currentObject, propName, token);
    }

    @NotNull
    public static final /* synthetic */ Token access$nextToken(Parser $this) {
        return $this.nextToken();
    }
}

