/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.avro;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.reflect.ReflectData;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.avro.AvroConversions;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.base.Configs;
import org.kitesdk.morphline.stdio.AbstractParser;

public final class ToAvroBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("toAvro");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ToAvro(this, config, parent, child, context);
    }

    private static final class ToAvro
    extends AbstractCommand {
        private final Map<String, String> mappings = new HashMap<String, String>();
        private final Schema fixedSchema;
        private final String schemaField;

        public ToAvro(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            String schemaFile = this.getConfigs().getString(config, "schemaFile", null);
            String schemaString = this.getConfigs().getString(config, "schemaString", null);
            this.schemaField = this.getConfigs().getString(config, "schemaField", null);
            int numDefinitions = 0;
            if (schemaFile != null) {
                ++numDefinitions;
            }
            if (schemaString != null) {
                ++numDefinitions;
            }
            if (this.schemaField != null) {
                ++numDefinitions;
            }
            if (numDefinitions == 0) {
                throw new MorphlineCompilationException("Either schemaFile or schemaString or schemaField must be defined", config);
            }
            if (numDefinitions > 1) {
                throw new MorphlineCompilationException("Must define only one of schemaFile or schemaString or schemaField at the same time", config);
            }
            if (schemaString != null) {
                this.fixedSchema = new Schema.Parser().parse(schemaString);
            } else if (schemaFile != null) {
                try {
                    this.fixedSchema = new Schema.Parser().parse(new File(schemaFile));
                }
                catch (IOException e) {
                    throw new MorphlineCompilationException("Cannot parse external Avro schema file: " + schemaFile, config, (Throwable)e);
                }
            } else {
                this.fixedSchema = null;
            }
            Config mappingsConfig = this.getConfigs().getConfig(config, "mappings", ConfigFactory.empty());
            for (Map.Entry entry : new Configs().getEntrySet(mappingsConfig)) {
                this.mappings.put((String)entry.getKey(), entry.getValue().toString());
            }
            this.validateArguments();
        }

        protected boolean doProcess(Record inputRecord) {
            Schema schema;
            if (this.schemaField != null) {
                schema = (Schema)inputRecord.getFirstValue(this.schemaField);
                Preconditions.checkNotNull((Object)schema);
            } else {
                schema = this.fixedSchema;
            }
            Record outputRecord = inputRecord.copy();
            AbstractParser.removeAttachments((Record)outputRecord);
            GenericData.Record avroRecord = new GenericData.Record(schema);
            for (Schema.Field field : schema.getFields()) {
                String morphlineFieldName = this.mappings.get(field.name());
                if (morphlineFieldName == null) {
                    morphlineFieldName = field.name();
                }
                List list = inputRecord.get(morphlineFieldName);
                Object avroResult = AvroConversions.ERROR;
                if (field.schema().getType() == Schema.Type.ARRAY) {
                    avroResult = AvroConversions.toAvro((Object)list, field);
                } else if (list.size() == 0) {
                    try {
                        avroResult = ReflectData.get().getDefaultValue(field);
                    }
                    catch (AvroRuntimeException e) {
                        avroResult = AvroConversions.ERROR;
                    }
                } else if (list.size() == 1) {
                    avroResult = AvroConversions.toAvro(list.get(0), field);
                }
                if (avroResult == AvroConversions.ERROR) {
                    this.LOG.debug("Cannot convert item: {} to schema: {}", (Object)list, (Object)schema);
                    return false;
                }
                avroRecord.put(field.pos(), avroResult);
            }
            outputRecord.put("_attachment_body", (Object)avroRecord);
            return super.doProcess(outputRecord);
        }
    }
}

