/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.compression.impl;

import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.compression.impl.AbstractCompressor;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.compression.CompressedDataBuffer;
import org.nd4j.linalg.compression.CompressionDescriptor;
import org.nd4j.linalg.compression.CompressionType;
import org.nd4j.linalg.factory.Nd4j;

public class Int8
extends AbstractCompressor {
    public String getDescriptor() {
        return "INT8";
    }

    public CompressionType getCompressionType() {
        return CompressionType.LOSSY;
    }

    @Override
    public DataBuffer decompress(DataBuffer buffer) {
        DataBuffer result = Nd4j.getNDArrayFactory().convertDataEx(DataBuffer.TypeEx.INT8, buffer, this.getGlobalTypeEx());
        return result;
    }

    @Override
    public DataBuffer compress(DataBuffer buffer) {
        DataBuffer result = Nd4j.getNDArrayFactory().convertDataEx(Int8.getBufferTypeEx(buffer), buffer, DataBuffer.TypeEx.INT8);
        return result;
    }

    @Override
    protected CompressedDataBuffer compressPointer(DataBuffer.TypeEx srcType, Pointer srcPointer, int length, int elementSize) {
        BytePointer ptr = new BytePointer((long)length);
        CompressionDescriptor descriptor = new CompressionDescriptor();
        descriptor.setCompressedLength((long)(length * 1));
        descriptor.setOriginalLength((long)(length * elementSize));
        descriptor.setOriginalElementSize((long)elementSize);
        descriptor.setNumberOfElements((long)length);
        descriptor.setCompressionAlgorithm(this.getDescriptor());
        descriptor.setCompressionType(this.getCompressionType());
        CompressedDataBuffer buffer = new CompressedDataBuffer((Pointer)ptr, descriptor);
        Nd4j.getNDArrayFactory().convertDataEx(srcType, srcPointer, DataBuffer.TypeEx.INT8, (Pointer)ptr, (long)length);
        return buffer;
    }
}

