/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.routed.impl;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.neo4j.bolt.connection.AccessMode;
import org.neo4j.bolt.connection.AuthInfo;
import org.neo4j.bolt.connection.AuthToken;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionState;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.DatabaseName;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.ResponseHandler;
import org.neo4j.bolt.connection.TelemetryApi;
import org.neo4j.bolt.connection.TransactionType;
import org.neo4j.bolt.connection.exception.BoltFailureException;
import org.neo4j.bolt.connection.exception.BoltServiceUnavailableException;
import org.neo4j.bolt.connection.routed.RoutedBoltConnectionProvider;
import org.neo4j.bolt.connection.routed.impl.cluster.RoutingTableHandler;
import org.neo4j.bolt.connection.routed.impl.util.FutureUtil;
import org.neo4j.bolt.connection.summary.BeginSummary;
import org.neo4j.bolt.connection.summary.CommitSummary;
import org.neo4j.bolt.connection.summary.DiscardSummary;
import org.neo4j.bolt.connection.summary.LogoffSummary;
import org.neo4j.bolt.connection.summary.LogonSummary;
import org.neo4j.bolt.connection.summary.PullSummary;
import org.neo4j.bolt.connection.summary.ResetSummary;
import org.neo4j.bolt.connection.summary.RollbackSummary;
import org.neo4j.bolt.connection.summary.RouteSummary;
import org.neo4j.bolt.connection.summary.RunSummary;
import org.neo4j.bolt.connection.summary.TelemetrySummary;
import org.neo4j.bolt.connection.values.Value;

public class RoutedBoltConnection
implements BoltConnection {
    private final BoltConnection delegate;
    private final RoutingTableHandler routingTableHandler;
    private final AccessMode accessMode;
    private final RoutedBoltConnectionProvider provider;

    public RoutedBoltConnection(BoltConnection delegate, RoutingTableHandler routingTableHandler, AccessMode accessMode, RoutedBoltConnectionProvider provider) {
        this.delegate = Objects.requireNonNull(delegate);
        this.routingTableHandler = Objects.requireNonNull(routingTableHandler);
        this.accessMode = Objects.requireNonNull(accessMode);
        this.provider = Objects.requireNonNull(provider);
    }

    public CompletionStage<BoltConnection> onLoop() {
        return this.delegate.onLoop();
    }

    public CompletionStage<BoltConnection> route(DatabaseName databaseName, String impersonatedUser, Set<String> bookmarks) {
        return this.delegate.route(databaseName, impersonatedUser, bookmarks).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> beginTransaction(DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, TransactionType transactionType, Duration txTimeout, Map<String, Value> txMetadata, String txType, NotificationConfig notificationConfig) {
        return this.delegate.beginTransaction(databaseName, accessMode, impersonatedUser, bookmarks, transactionType, txTimeout, txMetadata, txType, notificationConfig).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> runInAutoCommitTransaction(DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, String query, Map<String, Value> parameters, Duration txTimeout, Map<String, Value> txMetadata, NotificationConfig notificationConfig) {
        return this.delegate.runInAutoCommitTransaction(databaseName, accessMode, impersonatedUser, bookmarks, query, parameters, txTimeout, txMetadata, notificationConfig).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> run(String query, Map<String, Value> parameters) {
        return this.delegate.run(query, parameters).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> pull(long qid, long request) {
        return this.delegate.pull(qid, request).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> discard(long qid, long number) {
        return this.delegate.discard(qid, number).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> commit() {
        return this.delegate.commit().thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> rollback() {
        return this.delegate.rollback().thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> reset() {
        return this.delegate.reset().thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> logoff() {
        return this.delegate.logoff().thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> logon(AuthToken authToken) {
        return this.delegate.logon(authToken).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> telemetry(TelemetryApi telemetryApi) {
        return this.delegate.telemetry(telemetryApi).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> clear() {
        return this.delegate.clear();
    }

    public CompletionStage<Void> flush(final ResponseHandler handler) {
        return this.delegate.flush(new ResponseHandler(){
            boolean notifyHandler = true;

            public void onError(Throwable throwable) {
                handler.onError(RoutedBoltConnection.this.handledError(throwable, this.notifyHandler));
                this.notifyHandler = false;
            }

            public void onBeginSummary(BeginSummary summary) {
                handler.onBeginSummary(summary);
            }

            public void onRunSummary(RunSummary summary) {
                handler.onRunSummary(summary);
            }

            public void onRecord(Value[] fields) {
                handler.onRecord(fields);
            }

            public void onPullSummary(PullSummary summary) {
                handler.onPullSummary(summary);
            }

            public void onDiscardSummary(DiscardSummary summary) {
                handler.onDiscardSummary(summary);
            }

            public void onCommitSummary(CommitSummary summary) {
                handler.onCommitSummary(summary);
            }

            public void onRollbackSummary(RollbackSummary summary) {
                handler.onRollbackSummary(summary);
            }

            public void onResetSummary(ResetSummary summary) {
                handler.onResetSummary(summary);
            }

            public void onRouteSummary(RouteSummary summary) {
                handler.onRouteSummary(summary);
            }

            public void onLogoffSummary(LogoffSummary summary) {
                handler.onLogoffSummary(summary);
            }

            public void onLogonSummary(LogonSummary summary) {
                handler.onLogonSummary(summary);
            }

            public void onTelemetrySummary(TelemetrySummary summary) {
                handler.onTelemetrySummary(summary);
            }

            public void onIgnored() {
                handler.onIgnored();
            }

            public void onComplete() {
                handler.onComplete();
            }
        });
    }

    public CompletionStage<Void> forceClose(String reason) {
        return this.delegate.forceClose(reason);
    }

    public CompletionStage<Void> close() {
        this.provider.decrementInUseCount(this.serverAddress());
        return this.delegate.close();
    }

    public CompletionStage<Void> setReadTimeout(Duration duration) {
        return this.delegate.setReadTimeout(duration);
    }

    public BoltConnectionState state() {
        return this.delegate.state();
    }

    public CompletionStage<AuthInfo> authInfo() {
        return this.delegate.authInfo();
    }

    public String serverAgent() {
        return this.delegate.serverAgent();
    }

    public BoltServerAddress serverAddress() {
        return this.delegate.serverAddress();
    }

    public BoltProtocolVersion protocolVersion() {
        return this.delegate.protocolVersion();
    }

    public boolean telemetrySupported() {
        return this.delegate.telemetrySupported();
    }

    public boolean serverSideRoutingEnabled() {
        return this.delegate.serverSideRoutingEnabled();
    }

    public Optional<Duration> defaultReadTimeout() {
        return this.delegate.defaultReadTimeout();
    }

    private Throwable handledError(Throwable receivedError, boolean notifyHandler) {
        Throwable error = FutureUtil.completionExceptionCause(receivedError);
        if (error instanceof BoltServiceUnavailableException) {
            BoltServiceUnavailableException boltServiceUnavailableException = (BoltServiceUnavailableException)error;
            return this.handledServiceUnavailableException(boltServiceUnavailableException, notifyHandler);
        }
        if (error instanceof BoltFailureException) {
            BoltFailureException boltFailureException = (BoltFailureException)error;
            return this.handledBoltFailureException(boltFailureException, notifyHandler);
        }
        return error;
    }

    private Throwable handledServiceUnavailableException(BoltServiceUnavailableException e, boolean notifyHandler) {
        if (notifyHandler) {
            this.routingTableHandler.onConnectionFailure(this.serverAddress());
        }
        return new BoltServiceUnavailableException(String.format("Server at %s is no longer available", this.serverAddress()), (Throwable)e);
    }

    private Throwable handledBoltFailureException(BoltFailureException e, boolean notifyHandler) {
        String errorCode = e.code();
        if (Objects.equals(errorCode, "Neo.TransientError.General.DatabaseUnavailable")) {
            if (notifyHandler) {
                this.routingTableHandler.onConnectionFailure(this.serverAddress());
            }
        } else if (RoutedBoltConnection.isFailureToWrite(errorCode)) {
            switch (this.accessMode) {
                case READ: {
                    break;
                }
                case WRITE: {
                    if (!notifyHandler) break;
                    this.routingTableHandler.onWriteFailure(this.serverAddress());
                }
            }
        }
        return e;
    }

    private static boolean isFailureToWrite(String errorCode) {
        return Objects.equals(errorCode, "Neo.ClientError.Cluster.NotALeader") || Objects.equals(errorCode, "Neo.ClientError.General.ForbiddenOnReadOnlyDatabase");
    }
}

