/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import io.netty.util.CharsetUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.spring.data.connection.RedissonReactiveKeyCommands;
import org.springframework.data.redis.connection.ReactiveClusterKeyCommands;
import org.springframework.data.redis.connection.ReactiveKeyCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class RedissonReactiveClusterKeyCommands
extends RedissonReactiveKeyCommands
implements ReactiveClusterKeyCommands {
    public RedissonReactiveClusterKeyCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    public Mono<List<ByteBuffer>> keys(RedisClusterNode node, ByteBuffer pattern) {
        Mono m = this.executorService.reactive(() -> {
            List futures = this.executorService.readAllAsync((Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.KEYS, new Object[]{RedissonReactiveClusterKeyCommands.toByteArray(pattern)});
            CompletableFuture<Void> ff = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            CompletableFuture future = ((CompletableFuture)ff.thenApply(r -> futures.stream().flatMap(f -> ((List)f.getNow(new ArrayList())).stream()).collect(Collectors.toList()))).toCompletableFuture();
            return new CompletableFutureWrapper(future);
        });
        return m.map(v -> v.stream().map(t -> ByteBuffer.wrap(t.getBytes(CharsetUtil.UTF_8))).collect(Collectors.toList()));
    }

    public Mono<ByteBuffer> randomKey(RedisClusterNode node) {
        RedisClient entry = this.getEntry(node);
        Mono m = this.executorService.reactive(() -> this.executorService.readRandomAsync(entry, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand)RedisCommands.RANDOM_KEY, new Object[0]));
        return m.map(v -> ByteBuffer.wrap(v));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>> rename(Publisher<ReactiveKeyCommands.RenameCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getNewKey(), (String)"New name must not be null!");
            byte[] keyBuf = RedissonReactiveClusterKeyCommands.toByteArray(command.getKey());
            byte[] newKeyBuf = RedissonReactiveClusterKeyCommands.toByteArray(command.getNewKey());
            if (this.executorService.getConnectionManager().calcSlot(keyBuf) == this.executorService.getConnectionManager().calcSlot(newKeyBuf)) {
                return super.rename(commands);
            }
            return this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.DUMP, new Object[]{keyBuf}).filter(Objects::nonNull).zipWith(Mono.defer(() -> this.pTtl(command.getKey()).filter(Objects::nonNull).map(ttl -> Math.max(0L, ttl)).switchIfEmpty(Mono.just((Object)0L)))).flatMap(valueAndTtl -> this.write(newKeyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.RESTORE, newKeyBuf, valueAndTtl.getT2(), valueAndTtl.getT1())).thenReturn((Object)new ReactiveRedisConnection.BooleanResponse(command, Boolean.valueOf(true))).doOnSuccess(ignored -> this.del(command.getKey()));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>> renameNX(Publisher<ReactiveKeyCommands.RenameCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getNewKey(), (String)"New name must not be null!");
            byte[] keyBuf = RedissonReactiveClusterKeyCommands.toByteArray(command.getKey());
            byte[] newKeyBuf = RedissonReactiveClusterKeyCommands.toByteArray(command.getNewKey());
            if (this.executorService.getConnectionManager().calcSlot(keyBuf) == this.executorService.getConnectionManager().calcSlot(newKeyBuf)) {
                return super.renameNX(commands);
            }
            return this.exists(command.getNewKey()).zipWith(this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.DUMP, new Object[]{keyBuf})).filter(newKeyExistsAndDump -> (Boolean)newKeyExistsAndDump.getT1() == false && Objects.nonNull(newKeyExistsAndDump.getT2())).map(Tuple2::getT2).zipWhen(value -> this.pTtl(command.getKey()).filter(Objects::nonNull).map(ttl -> Math.max(0L, ttl)).switchIfEmpty(Mono.just((Object)0L))).flatMap(valueAndTtl -> this.write(newKeyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.RESTORE, newKeyBuf, valueAndTtl.getT2(), valueAndTtl.getT1()).then(Mono.just((Object)true))).switchIfEmpty(Mono.just((Object)false)).doOnSuccess(didRename -> {
                if (didRename.booleanValue()) {
                    this.del(command.getKey());
                }
            }).map(didRename -> new ReactiveRedisConnection.BooleanResponse(command, didRename));
        });
    }
}

