/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.BoxesRunTime;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.SafeLongBigInt;
import spire.math.SafeLongLong;

public abstract class SafeLong$class {
    public static int signum(SafeLong $this) {
        return BoxesRunTime.unboxToInt($this.fold(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(long x$1) {
                return Long.signum(x$1);
            }

            public int apply$mcIJ$sp(long x$1) {
                return Long.signum(x$1);
            }
        }, new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(BigInt x$1) {
                return x$1.signum();
            }
        }));
    }

    public static SafeLong $plus(SafeLong $this, SafeLong rhs) {
        return (SafeLong)rhs.fold(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SafeLong $outer;

            public final SafeLong apply(long x$2) {
                return this.$outer.$plus(x$2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SafeLong $outer;

            public final SafeLong apply(BigInt x$3) {
                return this.$outer.$plus(x$3);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static SafeLong $minus(SafeLong $this, SafeLong rhs) {
        return (SafeLong)rhs.fold(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SafeLong $outer;

            public final SafeLong apply(long x$4) {
                return this.$outer.$minus(x$4);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SafeLong $outer;

            public final SafeLong apply(BigInt x$5) {
                return this.$outer.$minus(x$5);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static SafeLong $times(SafeLong $this, SafeLong rhs) {
        return (SafeLong)rhs.fold(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SafeLong $outer;

            public final SafeLong apply(long x$6) {
                return this.$outer.$times(x$6);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SafeLong $outer;

            public final SafeLong apply(BigInt x$7) {
                return this.$outer.$times(x$7);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static SafeLong $div(SafeLong $this, SafeLong rhs) {
        return (SafeLong)rhs.fold(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SafeLong $outer;

            public final SafeLong apply(long x$8) {
                return this.$outer.$div(x$8);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SafeLong $outer;

            public final SafeLong apply(BigInt x$9) {
                return this.$outer.$div(x$9);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static SafeLong $percent(SafeLong $this, SafeLong rhs) {
        return (SafeLong)rhs.fold(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SafeLong $outer;

            public final SafeLong apply(long x$10) {
                return this.$outer.$percent(x$10);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SafeLong $outer;

            public final SafeLong apply(BigInt x$11) {
                return this.$outer.$percent(x$11);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static SafeLong $div$tilde(SafeLong $this, SafeLong rhs) {
        return $this.$div(rhs);
    }

    public static Tuple2 $div$percent(SafeLong $this, SafeLong rhs) {
        return (Tuple2)rhs.fold(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SafeLong $outer;

            public final Tuple2<SafeLong, SafeLong> apply(long x$12) {
                return this.$outer.$div$percent(x$12);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SafeLong $outer;

            public final Tuple2<SafeLong, SafeLong> apply(BigInt x$13) {
                return this.$outer.$div$percent(x$13);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static SafeLong $amp(SafeLong $this, SafeLong rhs) {
        return (SafeLong)rhs.fold(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SafeLong $outer;

            public final SafeLong apply(long x$14) {
                return this.$outer.$amp(x$14);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SafeLong $outer;

            public final SafeLong apply(BigInt x$15) {
                return this.$outer.$amp(x$15);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static SafeLong $bar(SafeLong $this, SafeLong rhs) {
        return (SafeLong)rhs.fold(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SafeLong $outer;

            public final SafeLong apply(long x$16) {
                return this.$outer.$amp(x$16);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SafeLong $outer;

            public final SafeLong apply(BigInt x$17) {
                return this.$outer.$amp(x$17);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static SafeLong $up(SafeLong $this, SafeLong rhs) {
        return (SafeLong)rhs.fold(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SafeLong $outer;

            public final SafeLong apply(long x$18) {
                return this.$outer.$amp(x$18);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SafeLong $outer;

            public final SafeLong apply(BigInt x$19) {
                return this.$outer.$amp(x$19);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static SafeLong min(SafeLong $this, SafeLong that) {
        return $this.$less(that) ? $this : that;
    }

    public static SafeLong max(SafeLong $this, SafeLong that) {
        return $this.$greater(that) ? $this : that;
    }

    public static final SafeLong $times$times(SafeLong $this, int rhs) {
        return $this.pow(rhs);
    }

    public static final SafeLong pow(SafeLong $this, int rhs) {
        Predef$.MODULE$.assert(rhs >= 0);
        return SafeLong$class._pow($this, SafeLong$.MODULE$.one(), $this, rhs);
    }

    private static final SafeLong _pow(SafeLong $this, SafeLong total, SafeLong base, int exp) {
        while (exp != 0) {
            if ((exp & 1) == 1) {
                SafeLong safeLong = total.$times(base);
                exp >>= 1;
                base = base.$times(base);
                total = safeLong;
                continue;
            }
            exp >>= 1;
            base = base.$times(base);
        }
        return total;
    }

    public static final SafeLong modPow(SafeLong $this, int exp, SafeLong mod2) {
        Predef$.MODULE$.assert(exp >= 0);
        return SafeLong$class._modPow($this, SafeLong$.MODULE$.one().$percent(mod2), $this, exp, mod2);
    }

    private static final SafeLong _modPow(SafeLong $this, SafeLong total, SafeLong base, int exp, SafeLong mod2) {
        while (exp != 0) {
            if ((exp & 1) == 1) {
                SafeLong safeLong = total.$times(base).$percent(mod2);
                exp >>= 1;
                base = base.$times(base).$percent(mod2);
                total = safeLong;
                continue;
            }
            exp >>= 1;
            base = base.$times(base).$percent(mod2);
        }
        return total;
    }

    public static SafeLong abs(SafeLong $this) {
        return $this.compare(SafeLong$.MODULE$.zero()) < 0 ? $this.unary_$minus() : $this;
    }

    public static boolean isValidInt(SafeLong $this) {
        if ($this.isLong()) {
            long n = $this.toLong();
            return Integer.MIN_VALUE <= n && n <= Integer.MAX_VALUE;
        }
        return false;
    }

    public static boolean isValidLong(SafeLong $this) {
        if ($this.isLong()) {
            long n = $this.toLong();
            return Long.MIN_VALUE <= n && n <= Long.MAX_VALUE;
        }
        return false;
    }

    public static boolean isLong(SafeLong $this) {
        return BoxesRunTime.unboxToBoolean($this.fold(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$20) {
                return true;
            }

            public boolean apply$mcZJ$sp(long x$20) {
                return true;
            }
        }, new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BigInt x$21) {
                return false;
            }
        }));
    }

    public static boolean isBigInt(SafeLong $this) {
        return BoxesRunTime.unboxToBoolean($this.fold(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$22) {
                return false;
            }

            public boolean apply$mcZJ$sp(long x$22) {
                return false;
            }
        }, new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BigInt x$23) {
                return true;
            }
        }));
    }

    public static byte toByte(SafeLong $this) {
        return (byte)$this.toLong();
    }

    public static short toShort(SafeLong $this) {
        return (short)$this.toLong();
    }

    public static int toInt(SafeLong $this) {
        return (int)$this.toLong();
    }

    public static String toString(SafeLong $this) {
        return (String)$this.fold(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(long x$24) {
                return ((Object)BoxesRunTime.boxToLong((long)x$24)).toString();
            }
        }, new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(BigInt x$25) {
                return x$25.toString();
            }
        });
    }

    public static final boolean isWhole(SafeLong $this) {
        return true;
    }

    public static boolean isProbablePrime(SafeLong $this, int c) {
        return $this.toBigInt().isProbablePrime(c);
    }

    public static int bitLength(SafeLong $this) {
        return BoxesRunTime.unboxToInt($this.fold(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(long x$26) {
                return 64 - Long.numberOfLeadingZeros(x$26);
            }

            public int apply$mcIJ$sp(long x$26) {
                return 64 - Long.numberOfLeadingZeros(x$26);
            }
        }, new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(BigInt x$27) {
                return x$27.bitLength();
            }
        }));
    }

    public static SafeLong map(SafeLong $this, Function1 f, Function1 g) {
        return (SafeLong)$this.fold(new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$1;

            public final SafeLongLong apply(long x) {
                return new SafeLongLong(this.f$1.apply$mcJJ$sp(x));
            }
            {
                this.f$1 = f$1;
            }
        }, new Serializable($this, g){
            public static final long serialVersionUID = 0L;
            private final Function1 g$1;

            public final SafeLongBigInt apply(BigInt x) {
                return new SafeLongBigInt((BigInt)this.g$1.apply((Object)x));
            }
            {
                this.g$1 = g$1;
            }
        });
    }

    public static Object foldWith(SafeLong $this, SafeLong that, Function2 f, Function2 g) {
        return $this.fold(new Serializable($this, that, f, g){
            public static final long serialVersionUID = 0L;
            private final SafeLong that$1;
            public final Function2 f$2;
            public final Function2 g$2;

            public final A apply(long x) {
                return this.that$1.fold(new Serializable(this, x){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SafeLong$.anonfun.foldWith.1 $outer;
                    private final long x$33;

                    public final B apply(long x$28) {
                        return (B)this.$outer.f$2.apply((Object)BoxesRunTime.boxToLong((long)this.x$33), (Object)BoxesRunTime.boxToLong((long)x$28));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.x$33 = x$33;
                    }
                }, new Serializable(this, x){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SafeLong$.anonfun.foldWith.1 $outer;
                    private final long x$33;

                    public final C apply(BigInt x$29) {
                        return (C)this.$outer.g$2.apply((Object)package$.MODULE$.BigInt().apply(this.x$33), (Object)x$29);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.x$33 = x$33;
                    }
                });
            }
            {
                this.that$1 = that$1;
                this.f$2 = f$2;
                this.g$2 = g$2;
            }
        }, new Serializable($this, that, g){
            public static final long serialVersionUID = 0L;
            private final SafeLong that$1;
            private final Function2 g$2;

            public final C apply(BigInt x$30) {
                return (C)this.g$2.apply((Object)x$30, (Object)this.that$1.toBigInt());
            }
            {
                this.that$1 = that$1;
                this.g$2 = g$2;
            }
        });
    }

    public static void $init$(SafeLong $this) {
    }
}

