/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.map;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.CollectionFactory;
import org.springframework.data.keyvalue.core.AbstractKeyValueAdapter;
import org.springframework.data.keyvalue.core.ForwardingCloseableIterator;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MapKeyValueAdapter
extends AbstractKeyValueAdapter {
    private final Class<? extends Map> keySpaceMapType;
    private final Map<String, Map<Object, Object>> store;

    public MapKeyValueAdapter() {
        this(ConcurrentHashMap.class);
    }

    public MapKeyValueAdapter(Class<? extends Map> mapType) {
        this(CollectionFactory.createMap(mapType, (int)100), mapType);
    }

    public MapKeyValueAdapter(Map<String, Map<Object, Object>> store) {
        this(store, ClassUtils.getUserClass(store));
    }

    private MapKeyValueAdapter(Map<String, Map<Object, Object>> store, Class<? extends Map> keySpaceMapType) {
        Assert.notNull(store, (String)"Store must not be null.");
        Assert.notNull(keySpaceMapType, (String)"Map type to be used for key spaces must not be null!");
        this.store = store;
        this.keySpaceMapType = keySpaceMapType;
    }

    @Override
    public Object put(Object id, Object item, String keyspace) {
        Assert.notNull((Object)id, (String)"Cannot add item with null id.");
        Assert.notNull((Object)keyspace, (String)"Cannot add item for null collection.");
        return this.getKeySpaceMap(keyspace).put(id, item);
    }

    @Override
    public boolean contains(Object id, String keyspace) {
        return this.get(id, keyspace) != null;
    }

    @Override
    public long count(String keyspace) {
        return this.getKeySpaceMap(keyspace).size();
    }

    @Override
    public Object get(Object id, String keyspace) {
        Assert.notNull((Object)id, (String)"Cannot get item with null id.");
        return this.getKeySpaceMap(keyspace).get(id);
    }

    @Override
    public Object delete(Object id, String keyspace) {
        Assert.notNull((Object)id, (String)"Cannot delete item with null id.");
        return this.getKeySpaceMap(keyspace).remove(id);
    }

    public Collection<?> getAllOf(String keyspace) {
        return this.getKeySpaceMap(keyspace).values();
    }

    @Override
    public CloseableIterator<Map.Entry<Object, Object>> entries(String keyspace) {
        return new ForwardingCloseableIterator<Map.Entry<Object, Object>>(this.getKeySpaceMap(keyspace).entrySet().iterator());
    }

    @Override
    public void deleteAllOf(String keyspace) {
        this.getKeySpaceMap(keyspace).clear();
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    public void destroy() throws Exception {
        this.clear();
    }

    protected Map<Object, Object> getKeySpaceMap(String keyspace) {
        Assert.notNull((Object)keyspace, (String)"Collection must not be null for lookup!");
        return this.store.computeIfAbsent(keyspace, k -> CollectionFactory.createMap(this.keySpaceMapType, (int)1000));
    }
}

