/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.convention;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.ResolvableType;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.bean.override.BeanOverrideProcessor;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;
import org.springframework.test.context.bean.override.convention.TestBean;
import org.springframework.test.context.bean.override.convention.TestBeanOverrideHandler;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class TestBeanOverrideProcessor
implements BeanOverrideProcessor {
    TestBeanOverrideProcessor() {
    }

    @Override
    public TestBeanOverrideHandler createHandler(Annotation overrideAnnotation, Class<?> testClass, Field field) {
        Method factoryMethod;
        BeanOverrideStrategy strategy;
        if (!(overrideAnnotation instanceof TestBean)) {
            throw new IllegalStateException("Invalid annotation passed to %s: expected @TestBean on field %s.%s".formatted(this.getClass().getSimpleName(), field.getDeclaringClass().getName(), field.getName()));
        }
        TestBean testBean = (TestBean)overrideAnnotation;
        String beanName = !testBean.name().isBlank() ? testBean.name() : null;
        String methodName = testBean.methodName();
        BeanOverrideStrategy beanOverrideStrategy = strategy = testBean.enforceOverride() ? BeanOverrideStrategy.REPLACE : BeanOverrideStrategy.REPLACE_OR_CREATE;
        if (!methodName.isBlank()) {
            factoryMethod = this.findTestBeanFactoryMethod(testClass, field.getType(), methodName);
        } else {
            ArrayList<String> candidateMethodNames = new ArrayList<String>();
            candidateMethodNames.add(field.getName());
            if (beanName != null) {
                candidateMethodNames.add(beanName);
            }
            factoryMethod = this.findTestBeanFactoryMethod(testClass, field.getType(), candidateMethodNames);
        }
        return new TestBeanOverrideHandler(field, ResolvableType.forField((Field)field, testClass), beanName, strategy, factoryMethod);
    }

    Method findTestBeanFactoryMethod(Class<?> clazz, Class<?> methodReturnType, String ... methodNames) {
        return this.findTestBeanFactoryMethod(clazz, methodReturnType, List.of(methodNames));
    }

    Method findTestBeanFactoryMethod(Class<?> clazz, Class<?> methodReturnType, Collection<String> methodNames) {
        Assert.notEmpty(methodNames, (String)"At least one candidate method name is required");
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        LinkedHashSet<String> originalNames = new LinkedHashSet<String>(methodNames);
        for (String methodName : methodNames) {
            Class declaringClass;
            int indexOfHash = methodName.lastIndexOf(35);
            if (indexOfHash == -1) continue;
            String className = methodName.substring(0, indexOfHash).trim();
            Assert.hasText((String)className, () -> "No class name present in fully-qualified method name: " + methodName);
            String methodNameToUse = methodName.substring(indexOfHash + 1).trim();
            Assert.hasText((String)methodNameToUse, () -> "No method name present in fully-qualified method name: " + methodName);
            try {
                declaringClass = ClassUtils.forName((String)className, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException | LinkageError ex) {
                throw new IllegalStateException("Failed to load class for fully-qualified method name: " + methodName, ex);
            }
            Method externalMethod = ReflectionUtils.findMethod((Class)declaringClass, (String)methodNameToUse);
            Assert.state((externalMethod != null && Modifier.isStatic(externalMethod.getModifiers()) && methodReturnType.isAssignableFrom(externalMethod.getReturnType()) ? 1 : 0) != 0, () -> "No static method found named %s in %s with return type %s".formatted(methodNameToUse, className, methodReturnType.getName()));
            methods.add(externalMethod);
            originalNames.remove(methodName);
        }
        LinkedHashSet<String> supportedNames = new LinkedHashSet<String>(originalNames);
        ReflectionUtils.MethodFilter methodFilter = method -> Modifier.isStatic(method.getModifiers()) && supportedNames.contains(method.getName()) && methodReturnType.isAssignableFrom(method.getReturnType());
        TestBeanOverrideProcessor.findMethods(methods, clazz, methodFilter);
        String methodNamesDescription = supportedNames.stream().map(name -> name + "()").collect(Collectors.joining(" or "));
        Assert.state((!methods.isEmpty() ? 1 : 0) != 0, () -> "No static method found named %s in %s with return type %s".formatted(methodNamesDescription, clazz.getName(), methodReturnType.getName()));
        long uniqueMethodNameCount = methods.stream().map(Method::getName).distinct().count();
        Assert.state((uniqueMethodNameCount == 1L ? 1 : 0) != 0, () -> "Found %d competing static methods named %s in %s with return type %s".formatted(uniqueMethodNameCount, methodNamesDescription, clazz.getName(), methodReturnType.getName()));
        return (Method)methods.iterator().next();
    }

    private static Set<Method> findMethods(Set<Method> methods, Class<?> clazz, ReflectionUtils.MethodFilter methodFilter) {
        methods.addAll(MethodIntrospector.selectMethods(clazz, (ReflectionUtils.MethodFilter)methodFilter));
        if (methods.isEmpty() && TestContextAnnotationUtils.searchEnclosingClass(clazz)) {
            TestBeanOverrideProcessor.findMethods(methods, clazz.getEnclosingClass(), methodFilter);
        }
        return methods;
    }
}

