/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.json;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Hints;
import org.springframework.http.HttpLogging;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.ObjectUtils;

public abstract class Jackson2CodecSupport {
    public static final String JSON_VIEW_HINT = Jackson2CodecSupport.class.getName() + ".jsonView";
    static final String ACTUAL_TYPE_HINT = Jackson2CodecSupport.class.getName() + ".actualType";
    private static final String JSON_VIEW_HINT_ERROR = "@JsonView only supported for write hints with exactly 1 class argument: ";
    private static final List<MimeType> DEFAULT_MIME_TYPES = Collections.unmodifiableList(Arrays.asList(MediaType.APPLICATION_JSON, new MediaType("application", "*+json"), MediaType.APPLICATION_NDJSON));
    protected final Log logger = HttpLogging.forLogName(this.getClass());
    private final ObjectMapper objectMapper;
    private final List<MimeType> mimeTypes;

    protected Jackson2CodecSupport(ObjectMapper objectMapper, MimeType ... mimeTypes) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        this.objectMapper = objectMapper;
        this.mimeTypes = !ObjectUtils.isEmpty((Object[])mimeTypes) ? Collections.unmodifiableList(Arrays.asList(mimeTypes)) : DEFAULT_MIME_TYPES;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected List<MimeType> getMimeTypes() {
        return this.mimeTypes;
    }

    protected boolean supportsMimeType(@Nullable MimeType mimeType) {
        return mimeType == null || this.mimeTypes.stream().anyMatch(m -> m.isCompatibleWith(mimeType));
    }

    protected JavaType getJavaType(Type type, @Nullable Class<?> contextClass) {
        TypeFactory typeFactory = this.objectMapper.getTypeFactory();
        return typeFactory.constructType(GenericTypeResolver.resolveType((Type)type, contextClass));
    }

    protected Map<String, Object> getHints(ResolvableType resolvableType) {
        MethodParameter param = this.getParameter(resolvableType);
        if (param != null) {
            JsonView annotation;
            HashMap<String, Object> hints = null;
            if (resolvableType.hasGenerics()) {
                hints = new HashMap<String, Object>(2);
                hints.put(ACTUAL_TYPE_HINT, resolvableType);
            }
            if ((annotation = this.getAnnotation(param, JsonView.class)) != null) {
                Class[] classes = annotation.value();
                Assert.isTrue((classes.length == 1 ? 1 : 0) != 0, (String)(JSON_VIEW_HINT_ERROR + param));
                hints = hints != null ? hints : new HashMap<String, Object>(1);
                hints.put(JSON_VIEW_HINT, classes[0]);
            }
            if (hints != null) {
                return hints;
            }
        }
        return Hints.none();
    }

    @Nullable
    protected MethodParameter getParameter(ResolvableType type) {
        return type.getSource() instanceof MethodParameter ? (MethodParameter)type.getSource() : null;
    }

    @Nullable
    protected abstract <A extends Annotation> A getAnnotation(MethodParameter var1, Class<A> var2);
}

