/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetChatTitle
extends BotApiMethod<Boolean> {
    public static final String PATH = "setChatTitle";
    private static final String CHATID_FIELD = "chat_id";
    private static final String TITLE_FIELD = "title";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="title")
    private String title;

    public SetChatTitle() {
    }

    public SetChatTitle(String chatId, String title) {
        this.chatId = (String)Preconditions.checkNotNull((Object)chatId);
        this.title = (String)Preconditions.checkNotNull((Object)title);
    }

    public SetChatTitle(Long chatId, String title) {
        this.chatId = ((Long)Preconditions.checkNotNull((Object)chatId)).toString();
        this.title = (String)Preconditions.checkNotNull((Object)title);
    }

    public String getChatId() {
        return this.chatId;
    }

    public SetChatTitle setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public SetChatTitle setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public SetChatTitle setTitle(String title) {
        Objects.requireNonNull(title);
        this.title = title;
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error setting chat title", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.title == null || this.title.isEmpty()) {
            throw new TelegramApiValidationException("Title can't be empty", this);
        }
    }

    public String toString() {
        return "SetChatTitle{chatId='" + this.chatId + '\'' + ", title='" + this.title + '\'' + '}';
    }
}

