/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class InputLocationMessageContent
implements InputMessageContent {
    private static final String LATITUDE_FIELD = "latitude";
    private static final String LONGITUDE_FIELD = "longitude";
    private static final String LIVEPERIOD_FIELD = "live_period";
    @JsonProperty(value="latitude")
    private Float latitude;
    @JsonProperty(value="longitude")
    private Float longitude;
    @JsonProperty(value="live_period")
    private Integer livePeriod;

    public InputLocationMessageContent() {
    }

    public InputLocationMessageContent(Float latitude, Float longitude) {
        this.latitude = (Float)Preconditions.checkNotNull((Object)latitude);
        this.longitude = (Float)Preconditions.checkNotNull((Object)longitude);
    }

    public Float getLongitude() {
        return this.longitude;
    }

    public InputLocationMessageContent setLongitude(Float longitude) {
        Objects.requireNonNull(longitude);
        this.longitude = longitude;
        return this;
    }

    public Float getLatitude() {
        return this.latitude;
    }

    public InputLocationMessageContent setLatitude(Float latitude) {
        Objects.requireNonNull(latitude);
        this.latitude = latitude;
        return this;
    }

    public Integer getLivePeriod() {
        return this.livePeriod;
    }

    public InputLocationMessageContent setLivePeriod(Integer livePeriod) {
        this.livePeriod = livePeriod;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.latitude == null) {
            throw new TelegramApiValidationException("Latitude parameter can't be empty", this);
        }
        if (this.longitude == null) {
            throw new TelegramApiValidationException("Longitude parameter can't be empty", this);
        }
        if (this.livePeriod != null && (this.livePeriod < 60 || this.livePeriod > 86400)) {
            throw new TelegramApiValidationException("Live period parameter must be between 60 and 86400", this);
        }
    }

    public String toString() {
        return "InputLocationMessageContent{latitude=" + this.latitude + ", longitude=" + this.longitude + ", livePeriod=" + this.livePeriod + '}';
    }
}

