/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.nio.charset.Charset;
import org.tensorflow.DataType;
import org.tensorflow.Graph;
import org.tensorflow.Operation;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.Tensor;

public final class OperationBuilder {
    private long unsafeNativeHandle;
    private Graph graph;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationBuilder(Graph graph, String type, String name) {
        this.graph = graph;
        try (Graph.Reference r = graph.ref();){
            this.unsafeNativeHandle = OperationBuilder.allocate(r.nativeHandle(), type, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation build() {
        try (Graph.Reference r = this.graph.ref();){
            Operation op = new Operation(this.graph, OperationBuilder.finish(this.unsafeNativeHandle));
            this.unsafeNativeHandle = 0L;
            Operation operation = op;
            return operation;
        }
    }

    public OperationBuilder addInput(Output<?> input) {
        try (Graph.Reference r = this.graph.ref();){
            OperationBuilder.addInput(this.unsafeNativeHandle, input.op().getUnsafeNativeHandle(), input.index());
        }
        return this;
    }

    public OperationBuilder addControlInput(Operation control) {
        try (Graph.Reference r = this.graph.ref();){
            OperationBuilder.addControlInput(this.unsafeNativeHandle, control.getUnsafeNativeHandle());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder addInputList(Output<?>[] inputs) {
        try (Graph.Reference r = this.graph.ref();){
            long[] opHandles = new long[inputs.length];
            int[] indices = new int[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                opHandles[i] = inputs[i].op().getUnsafeNativeHandle();
                indices[i] = inputs[i].index();
            }
            OperationBuilder.addInputList(this.unsafeNativeHandle, opHandles, indices);
        }
        return this;
    }

    public OperationBuilder setDevice(String device) {
        try (Graph.Reference r = this.graph.ref();){
            OperationBuilder.setDevice(this.unsafeNativeHandle, device);
        }
        return this;
    }

    public OperationBuilder setAttr(String name, String value) {
        this.setAttr(name, value.getBytes(Charset.forName("UTF-8")));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String name, byte[] value) {
        try (Graph.Reference r = this.graph.ref();){
            OperationBuilder.setAttrString(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String name, long value) {
        try (Graph.Reference r = this.graph.ref();){
            OperationBuilder.setAttrInt(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String name, long[] value) {
        try (Graph.Reference r = this.graph.ref();){
            OperationBuilder.setAttrIntList(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String name, float value) {
        try (Graph.Reference r = this.graph.ref();){
            OperationBuilder.setAttrFloat(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String name, float[] value) {
        try (Graph.Reference r = this.graph.ref();){
            OperationBuilder.setAttrFloatList(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String name, boolean value) {
        try (Graph.Reference r = this.graph.ref();){
            OperationBuilder.setAttrBool(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String name, boolean[] value) {
        try (Graph.Reference r = this.graph.ref();){
            OperationBuilder.setAttrBoolList(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String name, DataType value) {
        try (Graph.Reference r = this.graph.ref();){
            OperationBuilder.setAttrType(this.unsafeNativeHandle, name, value.c());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String name, DataType[] value) {
        int[] ctypes = new int[value.length];
        for (int i = 0; i < value.length; ++i) {
            ctypes[i] = value[i].c();
        }
        try (Graph.Reference r = this.graph.ref();){
            OperationBuilder.setAttrTypeList(this.unsafeNativeHandle, name, ctypes);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String name, Tensor<?> value) {
        try (Graph.Reference r = this.graph.ref();){
            OperationBuilder.setAttrTensor(this.unsafeNativeHandle, name, value.getNativeHandle());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String name, Tensor<?>[] value) {
        long[] handles = new long[value.length];
        int idx = 0;
        for (Tensor<?> t : value) {
            handles[idx++] = t.getNativeHandle();
        }
        try (Graph.Reference r = this.graph.ref();){
            OperationBuilder.setAttrTensorList(this.unsafeNativeHandle, name, handles);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String name, Shape value) {
        try (Graph.Reference r = this.graph.ref();){
            OperationBuilder.setAttrShape(this.unsafeNativeHandle, name, value.asArray(), value.numDimensions());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationBuilder setAttr(String name, String[] value) {
        Charset utf8 = Charset.forName("UTF-8");
        Object[] objects = new Object[value.length];
        for (int i = 0; i < value.length; ++i) {
            objects[i] = value[i].getBytes(utf8);
        }
        try (Graph.Reference r = this.graph.ref();){
            OperationBuilder.setAttrStringList(this.unsafeNativeHandle, name, objects);
        }
        return this;
    }

    private static native long allocate(long var0, String var2, String var3);

    private static native long finish(long var0);

    private static native void addInput(long var0, long var2, int var4);

    private static native void addInputList(long var0, long[] var2, int[] var3);

    private static native void addControlInput(long var0, long var2);

    private static native void setDevice(long var0, String var2);

    private static native void setAttrString(long var0, String var2, byte[] var3);

    private static native void setAttrInt(long var0, String var2, long var3);

    private static native void setAttrIntList(long var0, String var2, long[] var3);

    private static native void setAttrFloat(long var0, String var2, float var3);

    private static native void setAttrFloatList(long var0, String var2, float[] var3);

    private static native void setAttrBool(long var0, String var2, boolean var3);

    private static native void setAttrBoolList(long var0, String var2, boolean[] var3);

    private static native void setAttrType(long var0, String var2, int var3);

    private static native void setAttrTypeList(long var0, String var2, int[] var3);

    private static native void setAttrTensor(long var0, String var2, long var3);

    private static native void setAttrTensorList(long var0, String var2, long[] var3);

    private static native void setAttrShape(long var0, String var2, long[] var3, int var4);

    private static native void setAttrStringList(long var0, String var2, Object[] var3);
}

