/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dict.applicationprocessor;

import org.tinygroup.application.Application;
import org.tinygroup.application.ApplicationProcessor;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.cache.Cache;
import org.tinygroup.cache.CacheInitConfig;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.config.impl.AbstractConfiguration;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.dict.DictManager;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.xmlparser.node.XmlNode;

public class DictLoadProcessor
extends AbstractConfiguration
implements ApplicationProcessor {
    private static final String DICT_NODE_PATH = "/application/dict-load-config";
    private static final String BEAN_NAME = "bean_name";
    private static final String STOP_CACHE_CLEAR = "stop_cache_clear";
    private String cacheBeanName;
    private DictManager manager;
    private CacheInitConfig config;
    private boolean canClear;

    public CacheInitConfig getConfig() {
        return this.config;
    }

    public void setConfig(CacheInitConfig config) {
        this.config = config;
    }

    public DictManager getManager() {
        return this.manager;
    }

    public void setManager(DictManager manager) {
        this.manager = manager;
    }

    public boolean isCanClear() {
        return this.canClear;
    }

    public void setCanClear(boolean canClear) {
        this.canClear = canClear;
    }

    public String getApplicationNodePath() {
        return DICT_NODE_PATH;
    }

    public String getComponentConfigPath() {
        return null;
    }

    public void start() {
        Cache cache = this.manager.getCache();
        if (cache == null) {
            cache = (Cache)BeanContainerFactory.getBeanContainer((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getBean(this.cacheBeanName);
        }
        cache.init(this.config.getRegion());
        this.manager.setCache(cache);
        this.manager.load();
    }

    public void init() {
    }

    public void stop() {
        if (this.canClear) {
            LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u6e05\u9664\u5b57\u5178\u7f13\u5b58");
            this.manager.clear();
            LOGGER.logMessage(LogLevel.INFO, "\u6e05\u9664\u5b57\u5178\u7f13\u5b58\u7ed3\u675f");
        }
    }

    public void setApplication(Application application) {
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        super.config(applicationConfig, componentConfig);
        this.cacheBeanName = ConfigurationUtil.getPropertyName((XmlNode)applicationConfig, (XmlNode)componentConfig, (String)BEAN_NAME);
        if (StringUtil.isBlank((String)this.cacheBeanName)) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u5fc5\u987b\u7684Cache Bean");
        }
        String clearMark = ConfigurationUtil.getPropertyName((XmlNode)applicationConfig, (XmlNode)componentConfig, (String)STOP_CACHE_CLEAR);
        if (!StringUtil.isBlank((String)clearMark)) {
            this.canClear = Boolean.parseBoolean(clearMark);
        }
    }

    public int getOrder() {
        return 0;
    }
}

