/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dict.fileresolver;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.dict.DictLoader;
import org.tinygroup.dict.DictManager;
import org.tinygroup.dict.config.DictLoaderConfig;
import org.tinygroup.dict.config.DictLoaderConfigs;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class DictLoadFileProcessor
extends AbstractFileProcessor {
    private static final String DICT_LOAND_EXT_NAME = ".dictloader.xml";
    private DictManager manager;

    public DictManager getManager() {
        return this.manager;
    }

    public void setManager(DictManager manager) {
        this.manager = manager;
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(DICT_LOAND_EXT_NAME);
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)"dict");
        LOGGER.logMessage(LogLevel.INFO, "\u5b57\u5178\u52a0\u8f7d\u5668\u914d\u7f6e\u6587\u4ef6\u5904\u7406\u5f00\u59cb");
        for (FileObject fileObject : this.fileObjects) {
            LOGGER.logMessage(LogLevel.INFO, "\u627e\u5230\u5b57\u5178\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6:[{}]", new Object[]{fileObject.getAbsolutePath()});
            InputStream inputStream = fileObject.getInputStream();
            DictLoaderConfigs configs = (DictLoaderConfigs)stream.fromXML(inputStream);
            try {
                inputStream.close();
            }
            catch (Exception e) {
                LOGGER.errorMessage("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u51fa\u9519,\u6587\u4ef6\u8def\u5f84:{}", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
            }
            for (DictLoaderConfig config : configs.getConfigs()) {
                DictLoader dictLoader = (DictLoader)BeanContainerFactory.getBeanContainer((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getBean(config.getBeanName());
                dictLoader.setGroupName(config.getGroupName());
                dictLoader.setLanguage(config.getLanguage());
                this.manager.addDictLoader(dictLoader);
            }
        }
        LOGGER.logMessage(LogLevel.INFO, "\u5b57\u5178\u52a0\u8f7d\u5668\u914d\u7f6e\u6587\u4ef6\u5904\u7406\u7ed3\u675f");
    }

    public void setFileResolver(FileResolver fileResolver) {
    }
}

