/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dict.impl;

import org.tinygroup.context.Context;
import org.tinygroup.dict.Dict;
import org.tinygroup.dict.DictFilter;
import org.tinygroup.dict.DictLoader;
import org.tinygroup.dict.DictManager;

public abstract class AbstractDictLoader
implements DictLoader {
    private DictFilter dictFilter;
    private String groupName;
    private String language;

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public Dict getDict(String dictTypeName, DictManager dictManager, Context context) {
        try {
            Dict dict = (Dict)dictManager.getCache().get(this.getGroupName(), dictTypeName);
            if (dict != null && this.dictFilter != null) {
                dict = this.dictFilter.filte(context, dict);
            }
            return dict;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setDictFilter(DictFilter dictFilter) {
        this.dictFilter = dictFilter;
    }

    protected void putDict(String name, Dict dict, DictManager dictManager) {
        dictManager.getCache().put(this.getGroupName(), name, (Object)dict);
    }

    @Override
    public void clear(DictManager dictManager) {
        dictManager.getCache().cleanGroup(this.getGroupName());
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }
}

