/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dict.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.cache.Cache;
import org.tinygroup.commons.i18n.LocaleUtil;
import org.tinygroup.context.Context;
import org.tinygroup.dict.Dict;
import org.tinygroup.dict.DictLoader;
import org.tinygroup.dict.DictManager;
import org.tinygroup.dict.exception.DictRuntimeException;

public class DictManagerImpl
implements DictManager {
    private Map<String, List<DictLoader>> dictLoaderMap = new HashMap<String, List<DictLoader>>();
    private Cache cache;

    @Override
    public void load(DictLoader dictLoader) {
        dictLoader.load(this);
    }

    @Override
    public void load() {
        this.clear();
        for (List<DictLoader> dictLoaderList : this.dictLoaderMap.values()) {
            for (DictLoader tempDictLoader : dictLoaderList) {
                tempDictLoader.load(this);
            }
        }
    }

    @Override
    public Dict getDict(String dictTypeName, Context context) {
        String lang = LocaleUtil.getContext().getLocale().toString();
        return this.getDict(lang, dictTypeName, context);
    }

    @Override
    public Dict getDict(String lang, String dictTypeName, Context context) {
        if (!this.dictLoaderMap.containsKey(lang)) {
            throw new DictRuntimeException("0TE120018001", lang);
        }
        for (DictLoader dictLoader : this.dictLoaderMap.get(lang)) {
            Dict dict = dictLoader.getDict(dictTypeName, this, context);
            if (dict == null) continue;
            return dict;
        }
        throw new DictRuntimeException("0TE120018002", dictTypeName);
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public void clear() {
        for (List<DictLoader> dictLoaderList : this.dictLoaderMap.values()) {
            for (DictLoader tempDictLoader : dictLoaderList) {
                tempDictLoader.clear(this);
            }
        }
    }

    @Override
    public void clear(DictLoader dictLoader) {
        dictLoader.clear(this);
    }

    @Override
    public void addDictLoader(DictLoader dictLoader) {
        List<DictLoader> dictLoaderList;
        String lang = dictLoader.getLanguage();
        if (lang == null || lang.length() == 0) {
            lang = LocaleUtil.getContext().getLocale().toString();
        }
        if ((dictLoaderList = this.dictLoaderMap.get(lang)) == null) {
            dictLoaderList = new ArrayList<DictLoader>();
            this.dictLoaderMap.put(lang, dictLoaderList);
        }
        dictLoaderList.add(dictLoader);
    }
}

