/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.event;

import java.io.Serializable;
import java.util.UUID;
import org.tinygroup.context.Context;
import org.tinygroup.event.ServiceRequest;

public final class Event
implements Serializable {
    public static final int EVENT_TYPE_REQUEST = 1;
    public static final int EVENT_TYPE_RESPONSE = 2;
    public static final int EVENT_MODE_SYNCHRONOUS = 1;
    public static final int EVENT_MODE_ASYNCHRONOUS = 2;
    private static final long serialVersionUID = -1789684514322963288L;
    private int type = 1;
    private String eventId;
    private ServiceRequest serviceRequest;
    private Throwable throwable;
    private int priority;
    private int mode = 1;
    private boolean groupMode = false;

    public Event() {
        this.eventId = UUID.randomUUID().toString();
    }

    public Event(String eventId) {
        this.eventId = eventId;
    }

    public static Event createEvent(String serviceId, String nodeName, Context context) {
        Event event = Event.createEvent(serviceId, context);
        event.getServiceRequest().setNodeName(nodeName);
        return event;
    }

    public static Event createEvent(String serviceId, Context context) {
        Event event = new Event();
        ServiceRequest serviceRequest = new ServiceRequest();
        serviceRequest.setServiceId(serviceId);
        serviceRequest.setContext(context);
        event.setServiceRequest(serviceRequest);
        return event;
    }

    public boolean getGroupMode() {
        return this.groupMode;
    }

    public void setGroupMode(boolean groupMode) {
        this.groupMode = groupMode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public ServiceRequest getServiceRequest() {
        return this.serviceRequest;
    }

    public void setServiceRequest(ServiceRequest serviceRequest) {
        this.serviceRequest = serviceRequest;
    }
}

