/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jsqlparser.expression;

import org.tinygroup.jsqlparser.expression.Expression;
import org.tinygroup.jsqlparser.expression.ExpressionVisitor;

public class LongValue
implements Expression {
    private long value;
    private String stringValue;

    public LongValue(String value) {
        String val = value;
        if (val.charAt(0) == '+') {
            val = val.substring(1);
        }
        this.value = Long.parseLong(val);
        this.stringValue = val;
    }

    public LongValue(long value) {
        this.value = value;
        this.stringValue = String.valueOf(value);
    }

    public LongValue() {
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long d) {
        this.value = d;
        this.stringValue = d + "";
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String string) {
        this.stringValue = string;
    }

    public String toString() {
        return this.getStringValue();
    }
}

