/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jsqlparser.extend;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.tinygroup.jsqlparser.extend.ParameterExpressionVisitor;
import org.tinygroup.jsqlparser.extend.ParameterSelectVisitor;
import org.tinygroup.jsqlparser.statement.StatementVisitorAdapter;
import org.tinygroup.jsqlparser.statement.select.Select;
import org.tinygroup.jsqlparser.statement.select.WithItem;

public class ParameterFinder
extends StatementVisitorAdapter {
    private Map<String, Integer> positionMap = new HashMap<String, Integer>();
    private AtomicInteger paramLength = new AtomicInteger(0);

    @Override
    public void visit(Select select) {
        ParameterSelectVisitor selectVisitor = new ParameterSelectVisitor(this.positionMap, this.paramLength);
        ParameterExpressionVisitor expressionVisitor = new ParameterExpressionVisitor(this.positionMap, this.paramLength, selectVisitor);
        selectVisitor.setExpressionVisitor(expressionVisitor);
        if (select.getWithItemsList() != null && !select.getWithItemsList().isEmpty()) {
            for (WithItem withItem : select.getWithItemsList()) {
                withItem.accept(selectVisitor);
            }
        }
        select.getSelectBody().accept(selectVisitor);
    }

    private void init() {
        this.positionMap = new HashMap<String, Integer>();
        this.paramLength = new AtomicInteger(0);
    }

    public ParameterEntry getParameterEntry(Select select) {
        this.init();
        this.visit(select);
        return new ParameterEntry(this.positionMap, this.paramLength);
    }

    public class ParameterEntry {
        private Map<String, Integer> positionMap;
        private AtomicInteger paramLength;

        public ParameterEntry(Map<String, Integer> positionMap, AtomicInteger paramLength) {
            this.positionMap = positionMap;
            this.paramLength = paramLength;
        }

        public Map<String, Integer> getPositionMap() {
            return this.positionMap;
        }

        public int getParamLength() {
            return this.paramLength.get();
        }
    }
}

