/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jsqlparser.extend;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.tinygroup.jsqlparser.expression.Expression;
import org.tinygroup.jsqlparser.expression.ExpressionVisitorAdapter;
import org.tinygroup.jsqlparser.schema.Table;
import org.tinygroup.jsqlparser.statement.select.AllColumns;
import org.tinygroup.jsqlparser.statement.select.AllTableColumns;
import org.tinygroup.jsqlparser.statement.select.Fetch;
import org.tinygroup.jsqlparser.statement.select.FromItem;
import org.tinygroup.jsqlparser.statement.select.FromItemVisitor;
import org.tinygroup.jsqlparser.statement.select.Join;
import org.tinygroup.jsqlparser.statement.select.LateralSubSelect;
import org.tinygroup.jsqlparser.statement.select.Limit;
import org.tinygroup.jsqlparser.statement.select.Offset;
import org.tinygroup.jsqlparser.statement.select.OrderByElement;
import org.tinygroup.jsqlparser.statement.select.OrderByVisitor;
import org.tinygroup.jsqlparser.statement.select.Pivot;
import org.tinygroup.jsqlparser.statement.select.PivotVisitor;
import org.tinygroup.jsqlparser.statement.select.PivotXml;
import org.tinygroup.jsqlparser.statement.select.PlainSelect;
import org.tinygroup.jsqlparser.statement.select.SelectExpressionItem;
import org.tinygroup.jsqlparser.statement.select.SelectItem;
import org.tinygroup.jsqlparser.statement.select.SelectItemVisitor;
import org.tinygroup.jsqlparser.statement.select.SelectVisitor;
import org.tinygroup.jsqlparser.statement.select.SetOperationList;
import org.tinygroup.jsqlparser.statement.select.SubJoin;
import org.tinygroup.jsqlparser.statement.select.SubSelect;
import org.tinygroup.jsqlparser.statement.select.Top;
import org.tinygroup.jsqlparser.statement.select.ValuesList;
import org.tinygroup.jsqlparser.statement.select.WithItem;

public class ParameterSelectVisitor
implements SelectVisitor,
OrderByVisitor,
SelectItemVisitor,
FromItemVisitor,
PivotVisitor {
    private Map<String, Integer> positionMap;
    private AtomicInteger paramLength;
    private ExpressionVisitorAdapter expressionVisitor;

    public ParameterSelectVisitor(Map<String, Integer> positionMap, AtomicInteger paramLength) {
        this.positionMap = positionMap;
        this.paramLength = paramLength;
    }

    public ExpressionVisitorAdapter getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitorAdapter expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void visit(Pivot pivot) {
    }

    @Override
    public void visit(PivotXml pivot) {
    }

    @Override
    public void visit(Table tableName) {
    }

    @Override
    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept(this);
    }

    @Override
    public void visit(SubJoin subjoin) {
        subjoin.getLeft().accept(this);
        this.deparseJoin(subjoin.getJoin());
    }

    @Override
    public void visit(LateralSubSelect lateralSubSelect) {
        lateralSubSelect.getSubSelect().accept(this);
    }

    @Override
    public void visit(ValuesList valuesList) {
        valuesList.getMultiExpressionList().accept(this.expressionVisitor);
    }

    @Override
    public void visit(AllColumns allColumns) {
    }

    @Override
    public void visit(AllTableColumns allTableColumns) {
    }

    @Override
    public void visit(SelectExpressionItem selectExpressionItem) {
        selectExpressionItem.getExpression().accept(this.expressionVisitor);
    }

    @Override
    public void visit(OrderByElement orderBy) {
        orderBy.getExpression().accept(this.expressionVisitor);
    }

    @Override
    public void visit(PlainSelect plainSelect) {
        Top top;
        if (plainSelect.getDistinct() != null && plainSelect.getDistinct().getOnSelectItems() != null) {
            for (SelectItem selectItem : plainSelect.getDistinct().getOnSelectItems()) {
                selectItem.accept(this);
            }
        }
        if ((top = plainSelect.getTop()) != null && top.isRowCountJdbcParameter()) {
            this.positionMap.put("top", this.paramLength.incrementAndGet());
        }
        for (SelectItem selectItem : plainSelect.getSelectItems()) {
            selectItem.accept(this);
        }
        if (plainSelect.getFromItem() != null) {
            plainSelect.getFromItem().accept(this);
        }
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                this.deparseJoin(join);
            }
        }
        if (plainSelect.getWhere() != null) {
            plainSelect.getWhere().accept(this.expressionVisitor);
        }
        if (plainSelect.getOracleHierarchical() != null) {
            plainSelect.getOracleHierarchical().accept(this.expressionVisitor);
        }
        if (plainSelect.getGroupByColumnReferences() != null) {
            for (Expression columnReference : plainSelect.getGroupByColumnReferences()) {
                columnReference.accept(this.expressionVisitor);
            }
        }
        if (plainSelect.getHaving() != null) {
            plainSelect.getHaving().accept(this.expressionVisitor);
        }
        if (plainSelect.getOrderByElements() != null) {
            this.deparseOrderBy(plainSelect.isOracleSiblings(), plainSelect.getOrderByElements());
        }
        if (plainSelect.getLimit() != null) {
            this.deparseLimit(plainSelect.getLimit());
        }
        if (plainSelect.getOffset() != null) {
            this.deparseOffset(plainSelect.getOffset());
        }
        if (plainSelect.getFetch() != null) {
            this.deparseFetch(plainSelect.getFetch());
        }
    }

    public void deparseLimit(Limit limit) {
        if (limit.isOffsetJdbcParameter()) {
            this.positionMap.put("start", this.paramLength.incrementAndGet());
        }
        if (limit.isRowCountJdbcParameter()) {
            this.positionMap.put("limit", this.paramLength.incrementAndGet());
        }
    }

    public void deparseOffset(Offset offset) {
        if (offset.isOffsetJdbcParameter()) {
            this.positionMap.put("offset", this.paramLength.incrementAndGet());
        }
    }

    public void deparseFetch(Fetch fetch) {
        if (fetch.isFetchJdbcParameter()) {
            this.positionMap.put("fetch", this.paramLength.incrementAndGet());
        }
    }

    public void deparseOrderBy(List<OrderByElement> orderByElements) {
        this.deparseOrderBy(false, orderByElements);
    }

    public void deparseOrderBy(boolean oracleSiblings, List<OrderByElement> orderByElements) {
        for (OrderByElement orderByElement : orderByElements) {
            orderByElement.accept(this);
        }
    }

    public void deparseJoin(Join join) {
        FromItem fromItem = join.getRightItem();
        fromItem.accept(this);
        if (join.getOnExpression() != null) {
            join.getOnExpression().accept(this.expressionVisitor);
        }
    }

    @Override
    public void visit(SetOperationList list) {
        for (int i = 0; i < list.getPlainSelects().size(); ++i) {
            PlainSelect plainSelect = list.getPlainSelects().get(i);
            plainSelect.accept(this);
        }
        if (list.getOrderByElements() != null) {
            this.deparseOrderBy(list.getOrderByElements());
        }
        if (list.getLimit() != null) {
            this.deparseLimit(list.getLimit());
        }
        if (list.getOffset() != null) {
            this.deparseOffset(list.getOffset());
        }
        if (list.getFetch() != null) {
            this.deparseFetch(list.getFetch());
        }
    }

    @Override
    public void visit(WithItem withItem) {
        if (withItem.getWithItemList() != null) {
            for (SelectItem selectItem : withItem.getWithItemList()) {
                selectItem.accept(this);
            }
        }
        withItem.getSelectBody().accept(this);
    }
}

