/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jsqlparser.schema;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.jsqlparser.schema.MultiPartName;

public final class Server
implements MultiPartName,
Serializable {
    public static final Pattern SERVER_PATTERN = Pattern.compile("\\[([^\\]]+?)(?:\\\\([^\\]]+))?\\]");
    private String serverName;
    private String instanceName;

    public Server() {
    }

    public Server(String serverAndInstanceName) {
        if (serverAndInstanceName != null) {
            Matcher matcher = SERVER_PATTERN.matcher(serverAndInstanceName);
            if (!matcher.find()) {
                throw new IllegalArgumentException(String.format("%s is not a valid database reference", serverAndInstanceName));
            }
            this.setServerName(matcher.group(1));
            this.setInstanceName(matcher.group(2));
        }
    }

    public Server(String serverName, String instanceName) {
        this.setServerName(serverName);
        this.setInstanceName(instanceName);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    @Override
    public String getFullyQualifiedName() {
        if (this.serverName != null && this.serverName != null && this.serverName.length() != 0 && this.instanceName != null && this.instanceName != null && this.instanceName.length() != 0) {
            return String.format("[%s\\%s]", this.serverName, this.instanceName);
        }
        if (this.serverName != null && this.serverName != null && this.serverName.length() != 0) {
            return String.format("[%s]", this.serverName);
        }
        return "";
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }
}

