/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jsqlparser.statement.create.table;

import java.util.List;
import org.tinygroup.jsqlparser.schema.Table;
import org.tinygroup.jsqlparser.statement.Statement;
import org.tinygroup.jsqlparser.statement.StatementVisitor;
import org.tinygroup.jsqlparser.statement.create.table.ColumnDefinition;
import org.tinygroup.jsqlparser.statement.create.table.Index;
import org.tinygroup.jsqlparser.statement.select.PlainSelect;
import org.tinygroup.jsqlparser.statement.select.Select;

public class CreateTable
implements Statement {
    private Table table;
    private boolean unlogged = false;
    private List<String> tableOptionsStrings;
    private List<ColumnDefinition> columnDefinitions;
    private List<Index> indexes;
    private Select select;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public boolean isUnlogged() {
        return this.unlogged;
    }

    public void setUnlogged(boolean unlogged) {
        this.unlogged = unlogged;
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public void setColumnDefinitions(List<ColumnDefinition> list) {
        this.columnDefinitions = list;
    }

    public List<?> getTableOptionsStrings() {
        return this.tableOptionsStrings;
    }

    public void setTableOptionsStrings(List<String> list) {
        this.tableOptionsStrings = list;
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<Index> list) {
        this.indexes = list;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public String toString() {
        String sql = "";
        sql = "CREATE " + (this.unlogged ? "UNLOGGED " : "") + "TABLE " + this.table;
        if (this.select != null) {
            sql = sql + " AS " + this.select.toString();
        } else {
            sql = sql + " (";
            sql = sql + PlainSelect.getStringList(this.columnDefinitions, true, false);
            if (this.indexes != null && this.indexes.size() != 0) {
                sql = sql + ", ";
                sql = sql + PlainSelect.getStringList(this.indexes);
            }
            sql = sql + ")";
            String options = PlainSelect.getStringList(this.tableOptionsStrings, false, false);
            if (options != null && options.length() > 0) {
                sql = sql + " " + options;
            }
        }
        return sql;
    }
}

