/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jsqlparser.statement.create.view;

import java.util.List;
import org.tinygroup.jsqlparser.schema.Table;
import org.tinygroup.jsqlparser.statement.Statement;
import org.tinygroup.jsqlparser.statement.StatementVisitor;
import org.tinygroup.jsqlparser.statement.select.PlainSelect;
import org.tinygroup.jsqlparser.statement.select.SelectBody;

public class CreateView
implements Statement {
    private Table view;
    private SelectBody selectBody;
    private boolean orReplace = false;
    private List<String> columnNames = null;
    private boolean materialized = false;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getView() {
        return this.view;
    }

    public void setView(Table view) {
        this.view = view;
    }

    public boolean isOrReplace() {
        return this.orReplace;
    }

    public void setOrReplace(boolean orReplace) {
        this.orReplace = orReplace;
    }

    public SelectBody getSelectBody() {
        return this.selectBody;
    }

    public void setSelectBody(SelectBody selectBody) {
        this.selectBody = selectBody;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public boolean isMaterialized() {
        return this.materialized;
    }

    public void setMaterialized(boolean materialized) {
        this.materialized = materialized;
    }

    public String toString() {
        StringBuilder sql = new StringBuilder("CREATE ");
        if (this.isOrReplace()) {
            sql.append("OR REPLACE ");
        }
        if (this.isMaterialized()) {
            sql.append("MATERIALIZED ");
        }
        sql.append("VIEW ");
        sql.append(this.view);
        if (this.columnNames != null) {
            sql.append(PlainSelect.getStringList(this.columnNames, true, true));
        }
        sql.append(" AS ").append(this.selectBody);
        return sql.toString();
    }
}

