/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jsqlparser.statement.select;

import java.util.List;
import org.tinygroup.jsqlparser.statement.select.Fetch;
import org.tinygroup.jsqlparser.statement.select.Limit;
import org.tinygroup.jsqlparser.statement.select.Offset;
import org.tinygroup.jsqlparser.statement.select.OrderByElement;
import org.tinygroup.jsqlparser.statement.select.PlainSelect;
import org.tinygroup.jsqlparser.statement.select.SelectBody;
import org.tinygroup.jsqlparser.statement.select.SelectVisitor;
import org.tinygroup.jsqlparser.statement.select.SetOperation;

public class SetOperationList
implements SelectBody {
    private List<PlainSelect> plainSelects;
    private List<SetOperation> operations;
    private List<OrderByElement> orderByElements;
    private Limit limit;
    private Offset offset;
    private Fetch fetch;

    @Override
    public void accept(SelectVisitor selectVisitor) {
        selectVisitor.visit(this);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    public List<PlainSelect> getPlainSelects() {
        return this.plainSelects;
    }

    public List<SetOperation> getOperations() {
        return this.operations;
    }

    public void setOpsAndSelects(List<PlainSelect> select, List<SetOperation> ops) {
        this.plainSelects = select;
        this.operations = ops;
        if (select.size() - 1 != ops.size()) {
            throw new IllegalArgumentException("list sizes are not valid");
        }
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    public Fetch getFetch() {
        return this.fetch;
    }

    public void setFetch(Fetch fetch) {
        this.fetch = fetch;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.plainSelects.size(); ++i) {
            if (i != 0) {
                buffer.append(" ").append(this.operations.get(i - 1).toString()).append(" ");
            }
            buffer.append("(").append(this.plainSelects.get(i).toString()).append(")");
        }
        if (this.orderByElements != null) {
            buffer.append(PlainSelect.orderByToString(this.orderByElements));
        }
        if (this.limit != null) {
            buffer.append(this.limit.toString());
        }
        if (this.offset != null) {
            buffer.append(this.offset.toString());
        }
        if (this.fetch != null) {
            buffer.append(this.fetch.toString());
        }
        return buffer.toString();
    }

    public static enum SetOperationType {
        INTERSECT,
        EXCEPT,
        MINUS,
        UNION;

    }
}

