/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jsqlparser.statement.update;

import java.util.List;
import org.tinygroup.jsqlparser.expression.Expression;
import org.tinygroup.jsqlparser.schema.Column;
import org.tinygroup.jsqlparser.schema.Table;
import org.tinygroup.jsqlparser.statement.Statement;
import org.tinygroup.jsqlparser.statement.StatementVisitor;
import org.tinygroup.jsqlparser.statement.select.FromItem;
import org.tinygroup.jsqlparser.statement.select.Join;
import org.tinygroup.jsqlparser.statement.select.PlainSelect;
import org.tinygroup.jsqlparser.statement.select.Select;

public class Update
implements Statement {
    private List<Table> tables;
    private Expression where;
    private List<Column> columns;
    private List<Expression> expressions;
    private FromItem fromItem;
    private List<Join> joins;
    private Select select;
    private boolean useColumnsBrackets = true;
    private boolean useSelect = false;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public void setTables(List<Table> list) {
        this.tables = list;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setWhere(Expression expression) {
        this.where = expression;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Expression> list) {
        this.expressions = list;
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public void setFromItem(FromItem fromItem) {
        this.fromItem = fromItem;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> joins) {
        this.joins = joins;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public boolean isUseColumnsBrackets() {
        return this.useColumnsBrackets;
    }

    public void setUseColumnsBrackets(boolean useColumnsBrackets) {
        this.useColumnsBrackets = useColumnsBrackets;
    }

    public boolean isUseSelect() {
        return this.useSelect;
    }

    public void setUseSelect(boolean useSelect) {
        this.useSelect = useSelect;
    }

    public String toString() {
        int i;
        StringBuilder b = new StringBuilder("UPDATE ");
        b.append(PlainSelect.getStringList(this.getTables(), true, false)).append(" SET ");
        if (!this.useSelect) {
            for (i = 0; i < this.getColumns().size(); ++i) {
                if (i != 0) {
                    b.append(", ");
                }
                b.append(this.columns.get(i)).append(" = ");
                b.append(this.expressions.get(i));
            }
        } else {
            if (this.useColumnsBrackets) {
                b.append("(");
            }
            for (i = 0; i < this.getColumns().size(); ++i) {
                if (i != 0) {
                    b.append(", ");
                }
                b.append(this.columns.get(i));
            }
            if (this.useColumnsBrackets) {
                b.append(")");
            }
            b.append(" = ");
            b.append("(").append(this.select).append(")");
        }
        if (this.fromItem != null) {
            b.append(" FROM ").append(this.fromItem);
            if (this.joins != null) {
                for (Join join : this.joins) {
                    if (join.isSimple()) {
                        b.append(", ").append(join);
                        continue;
                    }
                    b.append(" ").append(join);
                }
            }
        }
        if (this.where != null) {
            b.append(" WHERE ");
            b.append(this.where);
        }
        return b.toString();
    }
}

