/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jsqlparser.util.deparser;

import java.util.Iterator;
import org.tinygroup.jsqlparser.statement.create.table.ColumnDefinition;
import org.tinygroup.jsqlparser.statement.create.table.CreateTable;
import org.tinygroup.jsqlparser.statement.create.table.Index;

public class CreateTableDeParser {
    protected StringBuilder buffer;

    public CreateTableDeParser(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public void deParse(CreateTable createTable) {
        this.buffer.append("CREATE ");
        if (createTable.isUnlogged()) {
            this.buffer.append("UNLOGGED ");
        }
        this.buffer.append("TABLE ").append(createTable.getTable().getFullyQualifiedName());
        if (createTable.getSelect() != null) {
            this.buffer.append(" AS ").append(createTable.getSelect().toString());
        } else if (createTable.getColumnDefinitions() != null) {
            this.buffer.append(" (");
            Iterator<Object> iter = createTable.getColumnDefinitions().iterator();
            while (iter.hasNext()) {
                ColumnDefinition columnDefinition = iter.next();
                this.buffer.append(columnDefinition.getColumnName());
                this.buffer.append(" ");
                this.buffer.append(columnDefinition.getColDataType().toString());
                if (columnDefinition.getColumnSpecStrings() != null) {
                    for (String s : columnDefinition.getColumnSpecStrings()) {
                        this.buffer.append(" ");
                        this.buffer.append(s);
                    }
                }
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
            if (createTable.getIndexes() != null) {
                iter = createTable.getIndexes().iterator();
                while (iter.hasNext()) {
                    this.buffer.append(", ");
                    Index index = (Index)iter.next();
                    this.buffer.append(index.toString());
                }
            }
            this.buffer.append(")");
        }
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }
}

