/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jsqlparser.util.deparser;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.tinygroup.jsqlparser.expression.Alias;
import org.tinygroup.jsqlparser.expression.Expression;
import org.tinygroup.jsqlparser.expression.ExpressionVisitor;
import org.tinygroup.jsqlparser.schema.Column;
import org.tinygroup.jsqlparser.schema.Table;
import org.tinygroup.jsqlparser.statement.select.AllColumns;
import org.tinygroup.jsqlparser.statement.select.AllTableColumns;
import org.tinygroup.jsqlparser.statement.select.Fetch;
import org.tinygroup.jsqlparser.statement.select.FromItem;
import org.tinygroup.jsqlparser.statement.select.FromItemVisitor;
import org.tinygroup.jsqlparser.statement.select.Join;
import org.tinygroup.jsqlparser.statement.select.LateralSubSelect;
import org.tinygroup.jsqlparser.statement.select.Limit;
import org.tinygroup.jsqlparser.statement.select.Offset;
import org.tinygroup.jsqlparser.statement.select.OrderByElement;
import org.tinygroup.jsqlparser.statement.select.OrderByVisitor;
import org.tinygroup.jsqlparser.statement.select.Pivot;
import org.tinygroup.jsqlparser.statement.select.PivotVisitor;
import org.tinygroup.jsqlparser.statement.select.PivotXml;
import org.tinygroup.jsqlparser.statement.select.PlainSelect;
import org.tinygroup.jsqlparser.statement.select.SelectExpressionItem;
import org.tinygroup.jsqlparser.statement.select.SelectItem;
import org.tinygroup.jsqlparser.statement.select.SelectItemVisitor;
import org.tinygroup.jsqlparser.statement.select.SelectVisitor;
import org.tinygroup.jsqlparser.statement.select.SetOperationList;
import org.tinygroup.jsqlparser.statement.select.SubJoin;
import org.tinygroup.jsqlparser.statement.select.SubSelect;
import org.tinygroup.jsqlparser.statement.select.Top;
import org.tinygroup.jsqlparser.statement.select.ValuesList;
import org.tinygroup.jsqlparser.statement.select.WithItem;

public class SelectDeParser
implements SelectVisitor,
OrderByVisitor,
SelectItemVisitor,
FromItemVisitor,
PivotVisitor {
    protected StringBuilder buffer;
    protected ExpressionVisitor expressionVisitor;

    public SelectDeParser() {
    }

    public SelectDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        this.buffer = buffer;
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void visit(PlainSelect plainSelect) {
        Top top;
        this.buffer.append("SELECT ");
        if (plainSelect.getDistinct() != null) {
            this.buffer.append("DISTINCT ");
            if (plainSelect.getDistinct().getOnSelectItems() != null) {
                this.buffer.append("ON (");
                Iterator<SelectItem> iter = plainSelect.getDistinct().getOnSelectItems().iterator();
                while (iter.hasNext()) {
                    SelectItem selectItem = iter.next();
                    selectItem.accept(this);
                    if (!iter.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(") ");
            }
        }
        if ((top = plainSelect.getTop()) != null) {
            this.buffer.append(top).append(" ");
        }
        Iterator<Serializable> iter = plainSelect.getSelectItems().iterator();
        while (iter.hasNext()) {
            SelectItem selectItem = iter.next();
            selectItem.accept(this);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        if (plainSelect.getIntoTables() != null) {
            this.buffer.append(" INTO ");
            iter = plainSelect.getIntoTables().iterator();
            while (iter.hasNext()) {
                this.visit((Table)iter.next());
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
        if (plainSelect.getFromItem() != null) {
            this.buffer.append(" FROM ");
            plainSelect.getFromItem().accept(this);
        }
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                this.deparseJoin(join);
            }
        }
        if (plainSelect.getWhere() != null) {
            this.buffer.append(" WHERE ");
            plainSelect.getWhere().accept(this.expressionVisitor);
        }
        if (plainSelect.getOracleHierarchical() != null) {
            plainSelect.getOracleHierarchical().accept(this.expressionVisitor);
        }
        if (plainSelect.getGroupByColumnReferences() != null) {
            this.buffer.append(" GROUP BY ");
            iter = plainSelect.getGroupByColumnReferences().iterator();
            while (iter.hasNext()) {
                Expression columnReference = (Expression)iter.next();
                columnReference.accept(this.expressionVisitor);
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
        if (plainSelect.getHaving() != null) {
            this.buffer.append(" HAVING ");
            plainSelect.getHaving().accept(this.expressionVisitor);
        }
        if (plainSelect.getOrderByElements() != null) {
            this.deparseOrderBy(plainSelect.isOracleSiblings(), plainSelect.getOrderByElements());
        }
        if (plainSelect.getLimit() != null) {
            this.deparseLimit(plainSelect.getLimit());
        }
        if (plainSelect.getOffset() != null) {
            this.deparseOffset(plainSelect.getOffset());
        }
        if (plainSelect.getFetch() != null) {
            this.deparseFetch(plainSelect.getFetch());
        }
        if (plainSelect.isForUpdate()) {
            this.buffer.append(" FOR UPDATE");
        }
    }

    @Override
    public void visit(OrderByElement orderBy) {
        orderBy.getExpression().accept(this.expressionVisitor);
        if (!orderBy.isAsc()) {
            this.buffer.append(" DESC");
        } else if (orderBy.isAscDescPresent()) {
            this.buffer.append(" ASC");
        }
        if (orderBy.getNullOrdering() != null) {
            this.buffer.append(' ');
            this.buffer.append(orderBy.getNullOrdering() == OrderByElement.NullOrdering.NULLS_FIRST ? "NULLS FIRST" : "NULLS LAST");
        }
    }

    public void visit(Column column) {
        this.buffer.append(column.getFullyQualifiedName());
    }

    @Override
    public void visit(AllTableColumns allTableColumns) {
        this.buffer.append(allTableColumns.getTable().getFullyQualifiedName()).append(".*");
    }

    @Override
    public void visit(SelectExpressionItem selectExpressionItem) {
        selectExpressionItem.getExpression().accept(this.expressionVisitor);
        if (selectExpressionItem.getAlias() != null) {
            this.buffer.append(selectExpressionItem.getAlias().toString());
        }
    }

    @Override
    public void visit(SubSelect subSelect) {
        Alias alias;
        this.buffer.append("(");
        subSelect.getSelectBody().accept(this);
        this.buffer.append(")");
        Pivot pivot = subSelect.getPivot();
        if (pivot != null) {
            pivot.accept(this);
        }
        if ((alias = subSelect.getAlias()) != null) {
            this.buffer.append(alias.toString());
        }
    }

    @Override
    public void visit(Table tableName) {
        Alias alias;
        this.buffer.append(tableName.getFullyQualifiedName());
        Pivot pivot = tableName.getPivot();
        if (pivot != null) {
            pivot.accept(this);
        }
        if ((alias = tableName.getAlias()) != null) {
            this.buffer.append(alias);
        }
    }

    @Override
    public void visit(Pivot pivot) {
        List<Column> forColumns = pivot.getForColumns();
        this.buffer.append(" PIVOT (").append(PlainSelect.getStringList(pivot.getFunctionItems())).append(" FOR ").append(PlainSelect.getStringList(forColumns, true, forColumns != null && forColumns.size() > 1)).append(" IN ").append(PlainSelect.getStringList(pivot.getInItems(), true, true)).append(")");
    }

    @Override
    public void visit(PivotXml pivot) {
        List<Column> forColumns = pivot.getForColumns();
        this.buffer.append(" PIVOT XML (").append(PlainSelect.getStringList(pivot.getFunctionItems())).append(" FOR ").append(PlainSelect.getStringList(forColumns, true, forColumns != null && forColumns.size() > 1)).append(" IN (");
        if (pivot.isInAny()) {
            this.buffer.append("ANY");
        } else if (pivot.getInSelect() != null) {
            this.buffer.append(pivot.getInSelect());
        } else {
            this.buffer.append(PlainSelect.getStringList(pivot.getInItems()));
        }
        this.buffer.append("))");
    }

    public void deparseOrderBy(List<OrderByElement> orderByElements) {
        this.deparseOrderBy(false, orderByElements);
    }

    public void deparseOrderBy(boolean oracleSiblings, List<OrderByElement> orderByElements) {
        if (oracleSiblings) {
            this.buffer.append(" ORDER SIBLINGS BY ");
        } else {
            this.buffer.append(" ORDER BY ");
        }
        Iterator<OrderByElement> iter = orderByElements.iterator();
        while (iter.hasNext()) {
            OrderByElement orderByElement = iter.next();
            orderByElement.accept(this);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
    }

    public void deparseLimit(Limit limit) {
        if (limit.isRowCountJdbcParameter()) {
            this.buffer.append(" LIMIT ");
            this.buffer.append("?");
        } else if (limit.getRowCount() >= 0L) {
            this.buffer.append(" LIMIT ");
            this.buffer.append(limit.getRowCount());
        } else if (limit.isLimitNull()) {
            this.buffer.append(" LIMIT NULL");
        }
        if (limit.isOffsetJdbcParameter()) {
            this.buffer.append(" OFFSET ?");
        } else if (limit.getOffset() != 0L) {
            this.buffer.append(" OFFSET ").append(limit.getOffset());
        }
    }

    public void deparseOffset(Offset offset) {
        if (offset.isOffsetJdbcParameter()) {
            this.buffer.append(" OFFSET ?");
        } else if (offset.getOffset() != 0L) {
            this.buffer.append(" OFFSET ");
            this.buffer.append(offset.getOffset());
        }
        if (offset.getOffsetParam() != null) {
            this.buffer.append(" ").append(offset.getOffsetParam());
        }
    }

    public void deparseFetch(Fetch fetch) {
        this.buffer.append(" FETCH ");
        if (fetch.isFetchParamFirst()) {
            this.buffer.append("FIRST ");
        } else {
            this.buffer.append("NEXT ");
        }
        if (fetch.isFetchJdbcParameter()) {
            this.buffer.append("?");
        } else {
            this.buffer.append(fetch.getRowCount());
        }
        this.buffer.append(" ").append(fetch.getFetchParam()).append(" ONLY");
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }

    @Override
    public void visit(SubJoin subjoin) {
        this.buffer.append("(");
        subjoin.getLeft().accept(this);
        this.deparseJoin(subjoin.getJoin());
        this.buffer.append(")");
        if (subjoin.getPivot() != null) {
            subjoin.getPivot().accept(this);
        }
    }

    public void deparseJoin(Join join) {
        if (join.isSimple()) {
            this.buffer.append(", ");
        } else {
            if (join.isRight()) {
                this.buffer.append(" RIGHT");
            } else if (join.isNatural()) {
                this.buffer.append(" NATURAL");
            } else if (join.isFull()) {
                this.buffer.append(" FULL");
            } else if (join.isLeft()) {
                this.buffer.append(" LEFT");
            } else if (join.isCross()) {
                this.buffer.append(" CROSS");
            }
            if (join.isOuter()) {
                this.buffer.append(" OUTER");
            } else if (join.isInner()) {
                this.buffer.append(" INNER");
            }
            this.buffer.append(" JOIN ");
        }
        FromItem fromItem = join.getRightItem();
        fromItem.accept(this);
        if (join.getOnExpression() != null) {
            this.buffer.append(" ON ");
            join.getOnExpression().accept(this.expressionVisitor);
        }
        if (join.getUsingColumns() != null) {
            this.buffer.append(" USING (");
            Iterator<Column> iterator = join.getUsingColumns().iterator();
            while (iterator.hasNext()) {
                Column column = iterator.next();
                this.buffer.append(column.getFullyQualifiedName());
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
        }
    }

    @Override
    public void visit(SetOperationList list) {
        for (int i = 0; i < list.getPlainSelects().size(); ++i) {
            if (i != 0) {
                this.buffer.append(' ').append(list.getOperations().get(i - 1)).append(' ');
            }
            this.buffer.append("(");
            PlainSelect plainSelect = list.getPlainSelects().get(i);
            plainSelect.accept(this);
            this.buffer.append(")");
        }
        if (list.getOrderByElements() != null) {
            this.deparseOrderBy(list.getOrderByElements());
        }
        if (list.getLimit() != null) {
            this.deparseLimit(list.getLimit());
        }
        if (list.getOffset() != null) {
            this.deparseOffset(list.getOffset());
        }
        if (list.getFetch() != null) {
            this.deparseFetch(list.getFetch());
        }
    }

    @Override
    public void visit(WithItem withItem) {
        this.buffer.append(withItem.getName());
        if (withItem.getWithItemList() != null) {
            this.buffer.append(" ").append(PlainSelect.getStringList(withItem.getWithItemList(), true, true));
        }
        this.buffer.append(" AS (");
        withItem.getSelectBody().accept(this);
        this.buffer.append(")");
    }

    @Override
    public void visit(LateralSubSelect lateralSubSelect) {
        this.buffer.append(lateralSubSelect.toString());
    }

    @Override
    public void visit(ValuesList valuesList) {
        this.buffer.append(valuesList.toString());
    }

    @Override
    public void visit(AllColumns allColumns) {
        this.buffer.append('*');
    }
}

