/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jsqlparser.util.deparser;

import java.util.Iterator;
import org.tinygroup.jsqlparser.statement.StatementVisitor;
import org.tinygroup.jsqlparser.statement.Statements;
import org.tinygroup.jsqlparser.statement.alter.Alter;
import org.tinygroup.jsqlparser.statement.create.index.CreateIndex;
import org.tinygroup.jsqlparser.statement.create.table.CreateTable;
import org.tinygroup.jsqlparser.statement.create.view.CreateView;
import org.tinygroup.jsqlparser.statement.delete.Delete;
import org.tinygroup.jsqlparser.statement.drop.Drop;
import org.tinygroup.jsqlparser.statement.execute.Execute;
import org.tinygroup.jsqlparser.statement.insert.Insert;
import org.tinygroup.jsqlparser.statement.replace.Replace;
import org.tinygroup.jsqlparser.statement.select.Select;
import org.tinygroup.jsqlparser.statement.select.WithItem;
import org.tinygroup.jsqlparser.statement.truncate.Truncate;
import org.tinygroup.jsqlparser.statement.update.Update;
import org.tinygroup.jsqlparser.util.deparser.CreateIndexDeParser;
import org.tinygroup.jsqlparser.util.deparser.CreateTableDeParser;
import org.tinygroup.jsqlparser.util.deparser.CreateViewDeParser;
import org.tinygroup.jsqlparser.util.deparser.DeleteDeParser;
import org.tinygroup.jsqlparser.util.deparser.ExecuteDeParser;
import org.tinygroup.jsqlparser.util.deparser.ExpressionDeParser;
import org.tinygroup.jsqlparser.util.deparser.InsertDeParser;
import org.tinygroup.jsqlparser.util.deparser.ReplaceDeParser;
import org.tinygroup.jsqlparser.util.deparser.SelectDeParser;
import org.tinygroup.jsqlparser.util.deparser.UpdateDeParser;

public class StatementDeParser
implements StatementVisitor {
    protected StringBuilder buffer;

    public StatementDeParser() {
    }

    public StatementDeParser(StringBuilder buffer) {
        this.buffer = buffer;
    }

    @Override
    public void visit(CreateIndex createIndex) {
        CreateIndexDeParser createIndexDeParser = new CreateIndexDeParser(this.buffer);
        createIndexDeParser.deParse(createIndex);
    }

    @Override
    public void visit(CreateTable createTable) {
        CreateTableDeParser createTableDeParser = new CreateTableDeParser(this.buffer);
        createTableDeParser.deParse(createTable);
    }

    @Override
    public void visit(CreateView createView) {
        CreateViewDeParser createViewDeParser = new CreateViewDeParser(this.buffer);
        createViewDeParser.deParse(createView);
    }

    @Override
    public void visit(Delete delete) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        DeleteDeParser deleteDeParser = new DeleteDeParser(expressionDeParser, this.buffer);
        deleteDeParser.deParse(delete);
    }

    @Override
    public void visit(Drop drop) {
    }

    @Override
    public void visit(Insert insert) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        InsertDeParser insertDeParser = new InsertDeParser(expressionDeParser, selectDeParser, this.buffer);
        insertDeParser.deParse(insert);
    }

    @Override
    public void visit(Replace replace) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        ReplaceDeParser replaceDeParser = new ReplaceDeParser(expressionDeParser, selectDeParser, this.buffer);
        replaceDeParser.deParse(replace);
    }

    @Override
    public void visit(Select select) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        if (select.getWithItemsList() != null && !select.getWithItemsList().isEmpty()) {
            this.buffer.append("WITH ");
            Iterator<WithItem> iter = select.getWithItemsList().iterator();
            while (iter.hasNext()) {
                WithItem withItem = iter.next();
                withItem.accept(selectDeParser);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        select.getSelectBody().accept(selectDeParser);
    }

    @Override
    public void visit(Truncate truncate) {
    }

    @Override
    public void visit(Update update) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        UpdateDeParser updateDeParser = new UpdateDeParser(expressionDeParser, selectDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        updateDeParser.deParse(update);
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }

    @Override
    public void visit(Alter alter) {
    }

    @Override
    public void visit(Statements stmts) {
        stmts.accept(this);
    }

    @Override
    public void visit(Execute execute) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        ExecuteDeParser executeDeParser = new ExecuteDeParser(expressionDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        executeDeParser.deParse(execute);
    }
}

