/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.service.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.tinygroup.beancontainer.BeanContainer;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.beanutil.BeanUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.event.Parameter;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.service.ServiceProxy;
import org.tinygroup.service.annotation.ServiceComponent;
import org.tinygroup.service.annotation.ServiceMethod;
import org.tinygroup.service.annotation.ServiceParameter;
import org.tinygroup.service.annotation.ServiceResult;
import org.tinygroup.service.exception.ServiceLoadException;
import org.tinygroup.service.loader.AnnotationServiceLoader;
import org.tinygroup.service.registry.ServiceRegistry;
import org.tinygroup.service.registry.ServiceRegistryItem;
import org.tinygroup.service.release.ServiceReleaseManager;
import org.tinygroup.service.util.ServiceUtil;

public abstract class AbstractAnnotationServiceLoader
implements AnnotationServiceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAnnotationServiceLoader.class);

    @Override
    public void loadService(ServiceRegistry serviceRegistry, ClassLoader classLoader) throws ServiceLoadException {
        List<String> classNames = this.getClassNames();
        for (String className : classNames) {
            try {
                LOGGER.logMessage(LogLevel.INFO, "\u4ece{className}\u4e2d\u67e5\u627eServiceAnnotation", new Object[]{className});
                Class<?> clazz = classLoader.loadClass(className);
                ServiceComponent annotation = clazz.getAnnotation(ServiceComponent.class);
                if (annotation != null) {
                    this.registerServices(clazz, annotation, serviceRegistry);
                } else {
                    LOGGER.logMessage(LogLevel.INFO, "{className}\u4e2d\u65e0ServiceAnnotation", new Object[]{className});
                }
                LOGGER.logMessage(LogLevel.INFO, "\u4ece{className}\u4e2d\u67e5\u627eServiceAnnotation\u5b8c\u6210", new Object[]{className});
            }
            catch (Exception e) {
                LOGGER.error("service.loadServiceException", (Throwable)e, new Object[]{className});
            }
        }
    }

    @Override
    public void loadService(Class<?> clazz, Annotation annotation, ServiceRegistry serviceRegistry) {
        String className = clazz.getName();
        LOGGER.logMessage(LogLevel.INFO, "\u4ece{}\u4e2d\u67e5\u627eServiceAnnotation", new Object[]{className});
        try {
            this.registerServices(clazz, annotation, serviceRegistry);
        }
        catch (Exception e) {
            LOGGER.error("service.loadServiceException", (Throwable)e, new Object[]{className});
        }
    }

    @Override
    public void removeService(ServiceRegistry serviceRegistry, ClassLoader classLoader) {
        List<String> classNames = this.getClassNames();
        for (String className : classNames) {
            try {
                Class<?> clazz = classLoader.loadClass(className);
                ServiceComponent annotation = clazz.getAnnotation(ServiceComponent.class);
                if (annotation == null) continue;
                this.removeServices(clazz, serviceRegistry);
            }
            catch (Exception e) {
                LOGGER.log(LogLevel.ERROR, "service.loadServiceException", new Object[]{className});
            }
        }
    }

    private void removeServices(Class<?> clazz, ServiceRegistry serviceRegistry) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        for (Method method : clazz.getMethods()) {
            ServiceMethod annotation = method.getAnnotation(ServiceMethod.class);
            if (annotation == null) continue;
            String serviceId = this.getAnnotationStringValue(annotation, ServiceMethod.class, "serviceId");
            serviceRegistry.removeService(serviceId);
        }
    }

    private void registerServices(Class<?> clazz, Annotation annotation, ServiceRegistry serviceRegistry) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException, ServiceLoadException {
        ServiceRegistryItem item = new ServiceRegistryItem();
        LOGGER.logMessage(LogLevel.INFO, "\u8bfb\u53d6ServiceComponent: {}", new Object[]{clazz.getName()});
        this.registerServices(clazz, item, serviceRegistry);
    }

    private void registerServices(Class<?> clazz, ServiceRegistryItem superItem, ServiceRegistry serviceRegistry) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException, ServiceLoadException {
        for (Method method : clazz.getMethods()) {
            ServiceMethod annotation;
            if (method.isBridge() || (annotation = method.getAnnotation(ServiceMethod.class)) == null) continue;
            LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u52a0\u8f7d\u65b9\u6cd5{0}\u4e3a\u670d\u52a1", new Object[]{method.getName()});
            String serviceId = this.getAnnotationStringValue(annotation, ServiceMethod.class, "serviceId");
            if (StringUtil.isBlank((String)serviceId)) {
                serviceId = StringUtil.toCamelCase((String)clazz.getSimpleName()) + "." + StringUtil.toCamelCase((String)method.getName());
            }
            if (!ServiceReleaseManager.isAccept(serviceId)) {
                LOGGER.logMessage(LogLevel.INFO, "\u8fc7\u6ee4\u670d\u52a1\uff1a{0}", new Object[]{serviceId});
                continue;
            }
            ServiceRegistryItem item = new ServiceRegistryItem();
            String localName = this.getAnnotationStringValue(annotation, ServiceMethod.class, "localName");
            item.setLocalName(localName);
            String category = this.getAnnotationStringValue(annotation, ServiceMethod.class, "category");
            item.setCategory(category);
            String description = this.getAnnotationStringValue(annotation, ServiceMethod.class, "description");
            item.setDescription(description);
            item.setServiceId(serviceId);
            this.registerService(clazz, method, item);
            ServiceRegistryItem registryItem = ServiceUtil.copyServiceItem(item);
            registryItem.setServiceId(serviceId);
            serviceRegistry.registerService(registryItem);
            String alias = this.getAnnotationStringValue(annotation, ServiceMethod.class, "alias");
            if (!StringUtil.isBlank((String)alias)) {
                registryItem = ServiceUtil.copyServiceItem(item);
                registryItem.setServiceId(alias);
                serviceRegistry.registerService(registryItem);
            }
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7d\u65b9\u6cd5{0}\u4e3a\u670d\u52a1\u5b8c\u6bd5", new Object[]{method.getName()});
        }
    }

    private void registerService(Class<?> clazz, Method method, ServiceRegistryItem item) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException, ServiceLoadException {
        ServiceProxy serviceProxy = new ServiceProxy();
        serviceProxy.setServiceId(item.getServiceId());
        serviceProxy.setObjectInstance(this.getServiceInstance(clazz));
        serviceProxy.setMethod(method);
        this.getInputParameterNames(item, method, serviceProxy);
        this.getOutputParameterNames(item, clazz, method, serviceProxy);
        item.setService(serviceProxy);
    }

    protected Object getServiceInstance(Class<?> clazz) {
        ServiceComponent serviceComponent = clazz.getAnnotation(ServiceComponent.class);
        BeanContainer container = BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader());
        try {
            if (StringUtil.isBlank((String)serviceComponent.bean())) {
                return container.getBean(clazz);
            }
            return container.getBean(serviceComponent.bean());
        }
        catch (RuntimeException e) {
            LOGGER.logMessage(LogLevel.WARN, "\u67e5\u627eBean:{0}\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{1}", new Object[]{serviceComponent.bean(), e.getMessage()});
            if (!clazz.isInterface()) {
                try {
                    return clazz.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    private void getOutputParameterNames(ServiceRegistryItem item, Class<?> clazz, Method method, ServiceProxy serviceProxy) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ServiceLoadException {
        LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u52a0\u8f7d\u65b9\u6cd5\u5bf9\u5e94\u7684\u670d\u52a1\u51fa\u53c2,\u65b9\u6cd5{0},\u670d\u52a1:{1}", new Object[]{method.getName(), item.getServiceId()});
        Class<?> parameterType = method.getReturnType();
        ArrayList<Parameter> outputParameterDescriptors = new ArrayList<Parameter>();
        ServiceResult annotation = method.getAnnotation(ServiceResult.class);
        Parameter descriptor = new Parameter();
        if (this.implmentInterface(parameterType, Collection.class)) {
            Type genericReturnType = method.getGenericReturnType();
            if (genericReturnType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericReturnType;
                Type[] actualTypeArguments = pt.getActualTypeArguments();
                Class actualClass = (Class)actualTypeArguments[0];
                if (!ServiceUtil.assignFromSerializable(actualClass)) {
                    throw new ServiceLoadException("\u670d\u52a1\u8fd4\u56de\u503c\u4e3a\u96c6\u5408\u7c7b\u578b\uff0c\u5176\u4e2d\u5143\u7d20\u7c7b\u578b:<" + actualClass.getName() + ">\u5fc5\u987b\u5b9e\u73b0Serializable\u63a5\u53e3");
                }
                descriptor.setType(actualClass.getName());
            } else {
                descriptor.setType(Object.class.getName());
            }
            descriptor.setCollectionType(parameterType.getName());
        } else {
            if (!ServiceUtil.assignFromSerializable(parameterType)) {
                throw new ServiceLoadException("\u670d\u52a1\u8fd4\u56de\u503c\u7c7b\u578b:<" + parameterType.getName() + ">\u5fc5\u987b\u5b9e\u73b0Serializable\u63a5\u53e3");
            }
            descriptor.setType(parameterType.getName());
        }
        LOGGER.logMessage(LogLevel.INFO, "\u670d\u52a1\u51fa\u53c2type:{name}", new Object[]{descriptor.getType()});
        descriptor.setArray(parameterType.isArray());
        String name = null;
        if (annotation != null) {
            Boolean required = Boolean.valueOf(this.getAnnotationStringValue(annotation, ServiceResult.class, "required"));
            descriptor.setRequired(required.booleanValue());
            name = this.getAnnotationStringValue(annotation, ServiceResult.class, "name");
            String validatorSence = this.getAnnotationStringValue(annotation, ServiceResult.class, "validatorSence");
            descriptor.setValidatorSence(validatorSence);
            String localName = this.getAnnotationStringValue(annotation, ServiceResult.class, "localName");
            descriptor.setTitle(localName);
            String description = this.getAnnotationStringValue(annotation, ServiceResult.class, "description");
            descriptor.setDescription(description);
            boolean isArray = Boolean.valueOf(this.getAnnotationStringValue(annotation, ServiceResult.class, "isArray"));
            descriptor.setArray(isArray);
            LOGGER.logMessage(LogLevel.INFO, "\u670d\u52a1\u51fa\u53c2name:{name}", new Object[]{name});
        } else {
            LOGGER.logMessage(LogLevel.INFO, "\u670d\u52a1\u51fa\u53c2\u672a\u914d\u7f6e");
        }
        if (StringUtil.isBlank(name)) {
            name = StringUtil.toCamelCase((String)clazz.getSimpleName()) + "_" + StringUtil.toCamelCase((String)method.getName()) + "_" + "result";
        }
        descriptor.setName(name);
        serviceProxy.setOutputParameter(descriptor);
        outputParameterDescriptors.add(descriptor);
        item.setResults(outputParameterDescriptors);
        LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7d\u65b9\u6cd5\u5bf9\u5e94\u7684\u670d\u52a1\u51fa\u53c2\u5b8c\u6bd5,\u65b9\u6cd5{0},\u670d\u52a1:{1}", new Object[]{method.getName(), item.getServiceId()});
    }

    private void getInputParameterNames(ServiceRegistryItem item, Method method, ServiceProxy serviceProxy) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ServiceLoadException {
        LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u52a0\u8f7d\u65b9\u6cd5\u5bf9\u5e94\u7684\u670d\u52a1\u5165\u53c2,\u65b9\u6cd5{0}", new Object[]{method.getName()});
        String[] parameterNames = BeanUtil.getMethodParameterName(method.getDeclaringClass(), (Method)method);
        Annotation[][] annotations = method.getParameterAnnotations();
        Class<?>[] parameterTypes = method.getParameterTypes();
        ArrayList<Parameter> inputParameterDescriptors = new ArrayList<Parameter>();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Annotation annotation = this.getParameterAnnotation(annotations, i);
            Parameter descriptor = new Parameter();
            Class<?> parameterType = parameterTypes[i];
            if (this.implmentInterface(parameterType, Collection.class)) {
                ParameterizedType pt = (ParameterizedType)method.getGenericParameterTypes()[i];
                Type[] actualTypeArguments = pt.getActualTypeArguments();
                Class clazz = (Class)actualTypeArguments[0];
                if (!ServiceUtil.assignFromSerializable(clazz)) {
                    throw new ServiceLoadException("\u670d\u52a1\u53c2\u6570\u96c6\u5408\u7c7b\u578b\u4e2d\u5143\u7d20\u7c7b\u578b:<" + clazz.getName() + ">\u5fc5\u987b\u5b9e\u73b0Serializable\u63a5\u53e3");
                }
                descriptor.setType(clazz.getName());
                descriptor.setCollectionType(parameterType.getName());
            } else {
                if (!ServiceUtil.assignFromSerializable(parameterType)) {
                    throw new ServiceLoadException("\u670d\u52a1\u53c2\u6570\u7c7b\u578b:<" + parameterType.getName() + ">\u5fc5\u987b\u5b9e\u73b0Serializable\u63a5\u53e3");
                }
                if (parameterType.isArray()) {
                    descriptor.setType(parameterType.getComponentType().getName());
                    descriptor.setArray(true);
                } else {
                    descriptor.setType(parameterType.getName());
                }
            }
            if (annotation != null) {
                String name = this.getAnnotationStringValue(annotation, ServiceParameter.class, "name");
                if (name.length() == 0) {
                    name = parameterNames[i];
                }
                descriptor.setName(name);
                boolean required = Boolean.valueOf(this.getAnnotationStringValue(annotation, ServiceParameter.class, "required"));
                descriptor.setRequired(required);
                String validatorSence = this.getAnnotationStringValue(annotation, ServiceParameter.class, "validatorSence");
                descriptor.setValidatorSence(validatorSence);
                String localName = this.getAnnotationStringValue(annotation, ServiceParameter.class, "localName");
                descriptor.setTitle(localName);
                String description = this.getAnnotationStringValue(annotation, ServiceParameter.class, "description");
                descriptor.setDescription(description);
                String collectionType = this.getAnnotationStringValue(annotation, ServiceParameter.class, "collectionType");
                descriptor.setCollectionType(collectionType);
                boolean isArray = Boolean.valueOf(this.getAnnotationStringValue(annotation, ServiceParameter.class, "isArray"));
                descriptor.setArray(isArray);
            } else {
                descriptor.setName(parameterNames[i]);
            }
            inputParameterDescriptors.add(descriptor);
        }
        item.setParameters(inputParameterDescriptors);
        serviceProxy.setInputParameters(inputParameterDescriptors);
        LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7d\u65b9\u6cd5\u5bf9\u5e94\u7684\u670d\u52a1\u5165\u53c2\u5b8c\u6bd5,\u65b9\u6cd5{0}", new Object[]{method.getName()});
    }

    private boolean implmentInterface(Class<?> clazz, Class<?> interfaceClazz) {
        return interfaceClazz.isAssignableFrom(clazz);
    }

    Annotation getParameterAnnotation(Annotation[][] annotations, int index) {
        for (int i = 0; i < annotations[index].length; ++i) {
            if (!annotations[index][i].annotationType().equals(ServiceParameter.class)) continue;
            return annotations[index][i];
        }
        return null;
    }

    private String getAnnotationStringValue(Annotation annotation, Class<?> annotationClazz, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object[] args = null;
        Class<?>[] argsType = null;
        return annotationClazz.getMethod(name, argsType).invoke((Object)annotation, args).toString();
    }

    protected abstract List<String> getClassNames();
}

