/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.service.fileresolver;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.beancontainer.BeanContainer;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.fileresolver.FileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.service.ServiceProviderInterface;
import org.tinygroup.service.config.ServiceComponent;
import org.tinygroup.service.config.ServiceComponents;
import org.tinygroup.service.config.XmlConfigServiceLoader;
import org.tinygroup.service.exception.ServiceLoadException;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class XmlServiceFileProcessor
extends XmlConfigServiceLoader
implements FileProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlServiceFileProcessor.class);
    private static final String SERVICE_EXT_FILENAME = ".service.xml";
    private ServiceProviderInterface provider;
    private List<ServiceComponents> list = new ArrayList<ServiceComponents>();

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(SERVICE_EXT_FILENAME);
    }

    public ServiceProviderInterface getProvider() {
        return this.provider;
    }

    public void setProvider(ServiceProviderInterface provider) {
        this.provider = provider;
    }

    @Override
    public void process() {
        XStream stream = XStreamFactory.getXStream((String)"service");
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664Service\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            ServiceComponents components = (ServiceComponents)this.caches.get(fileObject.getAbsolutePath());
            if (components != null) {
                this.caches.remove(fileObject.getAbsolutePath());
            }
            this.removeServiceComponents(this.provider.getServiceRegistory(), components);
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664Service\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u8bfb\u53d6Service\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            try {
                ServiceComponents oldComponents = (ServiceComponents)this.caches.get(fileObject.getAbsolutePath());
                if (oldComponents != null) {
                    this.list.remove(oldComponents);
                }
                InputStream inputStream = fileObject.getInputStream();
                ServiceComponents components = (ServiceComponents)stream.fromXML(inputStream);
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    LOGGER.errorMessage("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u51fa\u9519,\u6587\u4ef6\u8def\u5f84:{}", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
                }
                this.list.add(components);
                this.caches.put(fileObject.getAbsolutePath(), components);
            }
            catch (Exception e) {
                LOGGER.errorMessage("\u8bfb\u53d6Service\u6587\u4ef6[{0}]\u51fa\u73b0\u5f02\u5e38", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
            }
            LOGGER.logMessage(LogLevel.INFO, "\u8bfb\u53d6Service\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        try {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u6ce8\u518cService");
            this.loadService(this.provider.getServiceRegistory(), this.getFileResolver().getClassLoader());
            LOGGER.logMessage(LogLevel.INFO, "\u6ce8\u518cService\u7ed3\u675f");
        }
        catch (ServiceLoadException e) {
            LOGGER.errorMessage("\u6ce8\u518cService\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e, new Object[0]);
        }
        this.list.clear();
    }

    @Override
    public void setConfigPath(String path) {
    }

    @Override
    protected List<ServiceComponents> getServiceComponents() {
        return this.list;
    }

    @Override
    protected Object getServiceInstance(ServiceComponent component) throws Exception {
        BeanContainer container = BeanContainerFactory.getBeanContainer((ClassLoader)this.getFileResolver().getClassLoader());
        try {
            if (component.getBean() == null || "".equals(component.getBean())) {
                Class<?> clazz = this.getFileResolver().getClassLoader().loadClass(component.getType());
                return container.getBean(clazz);
            }
            return container.getBean(component.getBean());
        }
        catch (Exception e) {
            if (component.getBean() == null || "".equals(component.getBean())) {
                LOGGER.logMessage(LogLevel.WARN, "\u67e5\u627eBean\uff1a{}\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e, new Object[]{component.getType()});
            } else {
                LOGGER.logMessage(LogLevel.WARN, "\u67e5\u627eBean\uff1a{}\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e, new Object[]{component.getBean()});
            }
            Class<?> clazz = Class.forName(component.getType());
            if (!clazz.isInterface()) {
                return clazz.newInstance();
            }
            throw e;
        }
    }
}

